
#include "misc.h"
#include "avra.h"
#include "device.h"

struct device device_list[] =
	{
	{       NULL, 4194304, 8388608, 65536, 0},
	{"AT90S1200",     512,       0,    64, DF_NO_MUL},
	{"AT90S2313",    1024,     128,   128, DF_NO_MUL},
	{"AT90S2323",    1024,     128,   128, DF_NO_MUL},
	{"AT90S2343",    1024,     128,   128, DF_NO_MUL},
	{"AT90S4414",    2048,     256,   256, DF_NO_MUL},
	{"AT90S4434",    2048,     256,   256, DF_NO_MUL},
	{"AT90S8515",    4096,     512,   512, DF_NO_MUL},
	{"AT90S8535",    4096,     512,   512, DF_NO_MUL},
	{"ATmega603",   32768,    4096,  2048, DF_NO_MUL},
	{"ATmega103",   65536,    4096,  4096, DF_NO_MUL},
	{NULL, 0, 0, 0, 0}
	};


struct device *get_device(char *name)
	{
	int i = 1;

	if(name == NULL)
		return(&device_list[0]);
	while(device_list[i].name)
		{
		if(!nocase_strcmp(name, device_list[i].name))
			return(&device_list[i]);
		i++;
		}
	return(NULL);
	}
