#include "header.h"

Line::Line() : Glyph() {
        black = new Color(0.0f,0.0f,0.0f);
        thin = new Brush(1.0);
        Resource::ref(black);
        Resource::ref(thin);
}

Line::~Line() {
        Resource::unref(black);
        Resource::unref(thin);
}

void Line::request(Requisition &req) const {
        Requirement rx(250.0,150.0,100.0,0.0f);
        Requirement ry(150.0,50.0,50.0,0.0f);

        req.require(Dimension_X,rx);
        req.require(Dimension_Y,ry);
}

void Line::allocate(Canvas* c,const Allocation &a,
                     Extension &ext) {
        ext.set(c, a);
}

void Line::draw(Canvas *c,const Allocation &a) const {
        Coord x1 = a.left();
        Coord y1 = a.bottom();
        Coord x2 = a.right();
        Coord y2 = a.top();

        c->new_path();
        c->move_to(x1,y1);
        c->line_to(x2,y2);
        c->close_path();
        c->stroke(black,thin);        
}
