#include <stdio.h>
#include <math.h>

double
llong2double(unsigned long long int l)
{
	union { double d; unsigned long long int l; } u;
	/* l=(l >> 32) | (l << 32); */
	u.l=l;
	return u.d;
}

float
int2float(unsigned long int l)
{
	union { float f; unsigned long int l; } u;
	u.l = l;
	return u.f;
}

void
printfloat(float f)
{
	double d = f;
	union { float f; unsigned int i; } u;

	u.f = f;
	if (isnan(d)) {
		puts("NaN (float from int)");
	} else {
		printf("%f (float) = 0x%08X (int)\n", d, u.i);
	}
}

void
printdouble(double d)
{
	union { double d; unsigned long long int l; } u;

	u.d = d;
	if (isnan(d)) {
		puts("NaN (double from long long int)");
	} else {
		printf("%f (double) = 0x%08X%08X (long long int)\n", d,
		       (unsigned int) (u.l / 0x100000000ULL),
		       (unsigned int) (u.l % 0x100000000ULL));
	}
}

int
main(int ac, char *av[])
{
	printfloat(int2float(0x7f800000UL));
	printfloat(int2float(0xff800000UL));
	printfloat(int2float(0x7f800001UL));
	printfloat(int2float(0x7fffffffUL));
	printfloat(int2float(0xff800001UL));
	printfloat(int2float(0xffffffffUL));
	printfloat(int2float(0x00000000UL));
	printfloat(int2float(0x80000000UL));
	printdouble(llong2double(0x7ff0000000000000ULL));
	printdouble(llong2double(0xfff0000000000000ULL));
	printdouble(llong2double(0x7ff0000000000001ULL));
	printdouble(llong2double(0x7fffffffffffffffULL));
	printdouble(llong2double(0xfff0000000000001ULL));
	printdouble(llong2double(0xffffffffffffffffULL));
	printdouble(llong2double(0x0000000000000000ULL));
	printdouble(llong2double(0x8000000000000000ULL));

	return 0;
}
