# copyright (C) 1997-98 Jean-Luc Fontaine (mailto:jfontain@mygale.org)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: canvaswm.tcl,v 1.2 1998/07/11 19:06:36 jfontain Exp $}

class canvasWindowManager {

    proc canvasWindowManager {this canvas} {
        set canvasWindowManager::($this,canvas) $canvas
    }

    proc ~canvasWindowManager {this} {
        variable ${this}handle

        foreach path [array names ${this}handle] {
            delete [set ${this}handle($path)]
        }
        catch {unset ${this}handle}
    }

    proc manage {this path} {
        variable ${this}handle

        set ${this}handle($path) [new handles $canvasWindowManager::($this,canvas) -path $path]
    }

    proc unmanage {this path} {
        variable ${this}handle

        delete [set ${this}handle($path)]
        unset ${this}handle($path)
    }

    proc configure {this path args} {
        variable ${this}handle

        eval composite::configure [set ${this}handle($path)] $args
    }

    proc getGeometry {this path} {                                                        ;# return x, y, width and height as a list
        variable ${this}handle

        return [handles::getGeometry [set ${this}handle($path)]]
    }

}
