/*
 * $Id: queue.h,v 1.8 1998/09/28 17:58:27 gregm Exp $
 * GXSNMP -- An snmp mangament application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Queue handling definitions/declarations.
 */
#ifndef __QUEUE_H__
#define __QUEUE_H__

/*
 * Basicly what should be in this is something that needs to be done
 * but can be 'queued' to be done when the app isn't doing anything.
 * This can be polling collectors, checking hosts, discovering the network
 * filling in the info on a newly added host.. etc..
 */
typedef struct __queue_entry_ {
  int        id;     /* A unique id for this item */
  int        type;   /* what type of entry is this?  to be detrmined*/
  time_t     time;                    /* Time we were invoked */
  time_t     time_last;               /* When we were last invoked. */
  void       (*queue_callback) ();    /* Function to call */
  gpointer   data;                    /* pass this to the above function */
} queue_entry;

typedef struct __q_oidentry {
  gchar      *name;
  gulong     *hl_variable;
  gulong     id [SNMP_SIZE_OBJECTID];
  int        id_len;
} q_oidentry;

/*
 * Global functions 
 */
int  get_next_queue_id          ();
int  add_queue_item             (queue_entry *entry);
int  remove_queue_item          (int id);
int  run_queue                  (gpointer data);      /* process _one_ entry */

/*
 * Queue Callback functions
 */
void     test_callback    (queue_entry *queue, gpointer data);
void     queue_get_load   (queue_entry *queue, gpointer data);

/*
 * Standard global panel functions
 */
void        open_queue_panel        (void);
void        hide_queue_panel        (void);
void        destroy_queue_panel     (void);
void        reset_queue_panel       (void);

/*
 * SNMP Callbacks
 */
gboolean queue_snmp_update_load (host_snmp *host, void *, SNMP_PDU *spdu, GSList *objs);

#endif

/* EOF */


