#! /bin/sh
#
# create a prototype for silo boot floppy image for dbootstrap
# (C) Eric Delaunay <delaunay@debian.org>, 1998

set -e
#set -v
set -x

. common.sh

arch="`dpkg --print-architecture`"

if [ $# != 4 ]; then
	echo "Usage: $0 archive-path image-name subarch blocks" >&2
	exit 1
fi

archive=$1
image=$2
subarch=$3
blocks=$4

loopdev=loop3
device=/dev/$loopdev

mountpoint=/var/tmp/mnt.siloproto
tmp=/var/tmp/silo_proto.$$

# clean up old run aborted
umount $mountpoint || umount $device || true
losetup -d $device || true

# set the size of the floppy image
dd if=/dev/zero of=$image bs=1024 count=$blocks

losetup $device $image
if [ ! -d $mountpoint ]; then
	mkdir $mountpoint
fi

if [ $arch = sparc ]; then
	# define floppy type
	case $blocks in
	1440)
		sectors=18 ;;
	720)
		sectors=9 ;;
	*)
		echo "unsupported floppy size ($blocks kB)" >&2
		exit 1
	esac
	# create a valid first sector (required by Sun to boot from floppy)
	# only one whole disk partition (#3)
	fdisk $device << EOF
0
2
$sectors
80
0



0
d
1
d
2
p
w
EOF
	# then create the filesystem
	# (get more space: -i 32768 on 1.44MB image gives only 48 inodes)
	mke2fs -i 32768 -m 0 $device $blocks

	# and mount the floppy image
	mount $device $mountpoint
	# get even more space (12KB)
	rmdir $mountpoint/lost+found
	# -> 1428KB free on the floppy image

	# fill it
	mkdir $mountpoint/boot
	silopkg=`make_paths silo`
	dpkg --extract $silopkg $tmp
	if [ x$subarch = xsun4u ]; then
		silo_data="$tmp/boot/ultra.b $tmp/boot/second.b"
		silo_opt=-u
	else
		silo_data="$tmp/boot/first.b $tmp/boot/second.b"
		silo_opt=-U
	fi
	silo_data="$silo_data $tmp/boot/fd.b"
	cp -p $silo_data $mountpoint/boot
	mkdir $mountpoint/etc
	cat > $mountpoint/etc/silo.conf << EOF
partition=3
root=/dev/fd0
timeout=100
image=/linux
label=linux
append="load_ramdisk=1 prompt_ramdisk=1"
read-write
EOF
	# run silo to register first & second stage loaders
	$tmp/sbin/silo $silo_opt -r $mountpoint
	# then cleanup
	rm -f $mountpoint/boot/old.b

	rm -fr $tmp &
fi

# clean up
umount $mountpoint
losetup -d $device
rmdir $mountpoint
ls -l $image
exit 0
