// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: event.cc,v 1.5 1998/10/24 22:46:02 jgg Exp $
/* ######################################################################
   
   Event - Defines all of the events
   
   Each external event that can enter a widget is define here. This is
   basically Mouse and Keyboard.
   
   A keyboard event is a single integer that is either the key (ie 'q') or
   a number > 1000 which represents some kind of special character.

   ###################################################################### */
									/*}}}*/
// Include Files							/*{{{*/
#ifdef __GNUG__
#pragma implementation "deity/event.h"
#endif
#include <deity/event.h>
#include <iostream.h>
#include <pthread.h>
									/*}}}*/

// MouseEvent::MouseEvent - Constructor					/*{{{*/
// ---------------------------------------------------------------------
/* Provide a base for the class */
MouseEvent::MouseEvent()
{
}
									/*}}}*/
// KeyEvent::KeyEvent - Constructor					/*{{{*/
// ---------------------------------------------------------------------
/* */
KeyEvent::KeyEvent() : Modifiers(0), Extended(None), Key(0)
{
}
									/*}}}*/
// operator << MouseEvent - Output the event to the stream		/*{{{*/
// ---------------------------------------------------------------------
/* */
ostream &operator << (ostream &stream,const MouseEvent &E)
{
   stream << "MouseEvent(Type:" << E.Type << "," << E.Pos << ",Prsd:" << (int)E.Button 
        << ",Clk:" << (int)E.Clicks << ",State:" << (int)E.ButtonState
        << ",Btn: " << (int)E.Button << ")";
   return stream;
}
									/*}}}*/
// operator << KeyEvent - Output the event to the stream		/*{{{*/
// ---------------------------------------------------------------------
/* */
ostream &operator << (ostream &stream,const KeyEvent &E)
{
   char *Trans[] = {"None","Up","Down","Enter","Left","Right","PgUp","PgDown",
               "Home","End","Delete","Backspace","Insert"};
   if (E.Extended <= KeyEvent::Insert)
      stream << "Event('" << E.Key << "' [" << (int)E.Key << "], " << 
      Trans[E.Extended] << " [" << (int)E.Extended << "])";
   else
      stream << "Event('" << E.Key << "' [" << (int)E.Key << "], " << 
      "??" << " [" << (int)E.Extended << "])";
   return stream;
}
									/*}}}*/

