// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: anchor.h,v 1.3 1998/10/25 06:34:43 jgg Exp $
/* ######################################################################

   Anchor - Widget anchoring mechanism
   
   This provides a way to position a widget inside of another widget and
   keep it there when the other widget resizes. A typical use would be to 
   layout the main screen of an application.
   
   It works by attaching a notification to the parent widget and then
   changing the size of the target widget whenever the parent changes.
   
   The type of anchor is a simple offset anchor. Each side of the widget
   can be anchored to the top/bot or left/right of the container widget
   and it will maintain it's relative location to that side. The
   default anchoring that is performed when no anchor is applied
   would be
     Anchor::LeftToLeft | Anchor::RightToLeft | 
     Anchor::TopToTop | Anchor::BotToTop
   
   Be sure to create it on the heap, it will be erased with the widget.
   
   ##################################################################### */
									/*}}}*/
// Header section: deity
#ifndef DEITY_ANCHOR_H
#define DEITY_ANCHOR_H

#ifdef __GNUG__
#pragma interface "deity/anchor.h"
#endif

#include <deity/notify.h>

class Anchor : public Notifyer
{
   protected:
   Widget *Target;
   unsigned int Flags;
   
   public:

   // Or these together to select the anchor style
   enum AnchorFlags 
   {
      LeftToLeft = 0,
      LeftToRight = (1 << 0),
      RightToLeft = 0,
      RightToRight = (1 << 1),
      TopToTop = 0,
      TopToBot = (1 << 2),
      BotToTop = 0,
      BotToBot = (1 << 3)
   };

   virtual bool Trigger(Widget *From,Tag ID,void *Data);

   Anchor(Widget *Target,unsigned int Flags);
};

#endif
