// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <stdio.h>
#include "Dtd.h"
#include "SgmlNode.h"

//=============================================================================
// Public methods.
//-----------------------------------------------------------------------------
SgmlNode::SgmlNode( Type type, SgmlNode* parent ) : _type( type ), _left( 0 ), _right( 0 ), _parent( parent )
{
}

SgmlNode::SgmlNode( SgmlNode* node, SgmlNode* parent ) : _type( node->type() ), _element( node->element() ), _left( 0 ), _right( 0 ), _parent( parent )
{
	if ( node->left() ) _left = new SgmlNode( node->left(), this );
	if ( node->right() ) _right = new SgmlNode( node->right(), this );
}

SgmlNode::~SgmlNode()
{
	if ( left() ) delete left();
	if ( right() ) delete right();
}

void SgmlNode::calculate()
{
	if ( left() ) left()->calculate();
	if ( right() ) right()->calculate();
	
	SgmlNode* n;
	SgmlNode* m;
	
	if ( !left() && !right() ) {
		if ( type() == Empty ) {
			_nullable = TRUE;
		} else {
			_nullable = FALSE;
			_firstpos.append( this );
			_lastpos.append( this );
		}
	} else if ( type() == Or ) {
		_nullable = left()->nullable() || right()->nullable();
		for ( n = left()->firstpos().first(); n; n = left()->firstpos().next() ) {
			_firstpos.append( n );
		}
		for ( n = right()->firstpos().first(); n; n = right()->firstpos().next() ) {
			_firstpos.append( n );
		}
		for ( n = left()->lastpos().first(); n; n = left()->lastpos().next() ) {
			_lastpos.append( n );
		}
		for ( n = right()->lastpos().first(); n; n = right()->lastpos().next() ) {
			_lastpos.append( n );
		}
	} else if ( type() == Seq ) {
		_nullable = left()->nullable() && right()->nullable();
		for ( n = left()->firstpos().first(); n; n = left()->firstpos().next() ) {
			_firstpos.append( n );
		}
		if ( left()->nullable() ) {
			for ( n = right()->firstpos().first(); n; n = right()->firstpos().next() ) {
				_firstpos.append( n );
			}
		}
		for ( n = right()->lastpos().first(); n; n = right()->lastpos().next() ) {
			_lastpos.append( n );
		}
		if ( right()->nullable() ) {
			for ( n = left()->lastpos().first(); n; n = left()->lastpos().next() ) {
				_lastpos.append( n );
			}
		}
		for ( n = left()->lastpos().first(); n; n = left()->lastpos().next() ) {
			for ( m = right()->firstpos().first(); m; m = right()->firstpos().next() ) {
				n->followpos().append( m );
			}
		}
	} else if ( type() == Star ) {
		_nullable = TRUE;
		for ( n = left()->firstpos().first(); n; n = left()->firstpos().next() ) {
			_firstpos.append( n );
		}
		for ( n = left()->lastpos().first(); n; n = left()->lastpos().next() ) {
			_lastpos.append( n );
		}
		for ( n = _lastpos.first(); n; n = _lastpos.next() ) {
			for ( m = _firstpos.first(); m; m = _firstpos.next() ) {
				n->followpos().append( m );
			}
		}
	}
}
