// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _ImageRenderer_h_
#define _ImageRenderer_h_

#include "FormObjectRenderer.h"

class ImageDecoder;
class Request;

//: The ImageRenderer class fetches, decodes, and displays a single inlined image.
//. The ImageRenderer class creates a request for the image data, and creates
//. an appropriate ImageDecoder to process the data.  The image decoder is
//. selected based on the Internet media type of the image data stream.
class ImageRenderer : public FormObjectRenderer {
    Q_OBJECT
    QString       _src;
    bool          _ismap;
    QString       _url;
    int           _x;
    int           _y;
    bool          _isSubmit;
    ImageDecoder* _decoder;
public:
    //. Create a new ImageReneder.  The src specifies the url for the image data.
    //. The width and height parameters give the width and height that the image
    //. should be.  A request is made for the image data.
    ImageRenderer( QString     src,
                   int         width,
                   int         height,
                   bool        ismap,
                   bool        isSubmit,
                   QString     url,
                   Canvas*     canvas,
                   int         clipWidth=0,
                   QObject*    parent=0,
                   const char* name=0 );

    //. Free the pixmap containing the image.
    virtual ~ImageRenderer();

    bool isSubmit() { return _isSubmit; }

    bool isMap() { return _ismap; }

    void setX( int x ) { _x = x; }

    void setY( int y ) { _y = y; }

    QString value();

    void reset();

    //. Set our minimum and maximum width to be the width of our QWidget.
    virtual bool redraw();

    void repaint( QPainter& p, const Rect& r );
public slots:
    //. Create an appropriate ImageDecoder based on the Internet media type of
    //. data stream.
    void startOfData( Request* req, QString mediaType, QString mediaSubtype, int size );

    void endOfData() {}
};

#endif
