// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "ContentModel.h"

ContentModel::~ContentModel()
{
    while ( _states.first() ) {
	delete _states.first();
	_states.remove();
    }
}

void ContentModel::addState( ContentModelState* state )
{
    _states.append( state );
}

ContentModelState* ContentModel::find( ContentModelState* state )
{
    SgmlNode*          n;
    SgmlNode*          m;
    ContentModelState* s;
	
    for ( s = _states.first(); s; s = _states.next() ) {
        bool same = TRUE;
        for ( n = s->id().first(), m = state->id().first(); n && same; n = s->id().next(), m = state->id().next() ) {
            if ( n != m ) same = FALSE;
        }
        if ( same ) return s;
    }
	
    return 0;
}
