// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <qchkbox.h>
#include "Canvas.h"
#include "CheckBoxRenderer.h"

CheckBoxRenderer::CheckBoxRenderer( bool           checked,
                                    const QString* value,
                                    Canvas*        canvas,
                                    int            clipWidth,
                                    QObject*       parent,
                                    const char*    name )
        : FormObjectRenderer( canvas, clipWidth, parent, name ),
          _checked( checked )
{
    if ( value ) {
        _value = value->copy();
    }
    
    _checkBox = new QCheckBox( canvas->clip() );
    _checkBox->setChecked( _checked );
    canvas->registerWidget( this, _checkBox );
    
    int w = _checkBox->sizeHint().width();
    int h = _checkBox->sizeHint().height();
    _checkBox->resize( w, h );
    _minimumWidth = w + 8;
    _maximumWidth = w + 8;

    resize( w + 8, h + 8 );
}

QString CheckBoxRenderer::value()
{
    if ( _checkBox->isChecked() ) {
        QString nm  = name();
        QString val = _value.copy();
        
        if ( ( nm.length() == 0 ) || ( val.length() == 0 ) ) {
            return "";
        }
        
        Url::encode( nm );
        Url::encode( val );
        
        QString tmp;
        tmp.sprintf( "%s=%s", nm.data(), val.data() );
        return tmp;
    } else {
        return 0;
    }
}

void CheckBoxRenderer::reset()
{
    _checkBox->setChecked( _checked );
}

bool CheckBoxRenderer::redraw()
{
    return FALSE;
}

void CheckBoxRenderer::endOfData()
{
}
