# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <fcntl.h>

# include "hfs.h"
# include "hcwd.h"
# include "hfsutil.h"
# include "glob.h"
# include "hcd.h"

/*
 * NAME:	hcd->main()
 * DESCRIPTION:	implement hcd command
 */
int hcd_main(int argc, char *argv[])
{
  mountent *ment;
  hfsvol *vol;
  hfsvolent vent;
  char *path, root[29];
  int fargc;
  char **fargv = 0;
  int result = 0;

  if (argc > 2)
    {
      fprintf(stderr, "Usage: %s [hfs-path]\n", argv[0]);
      return 1;
    }

  vol = hfs_remount(ment = hcwd_getvol(-1), O_RDONLY);
  if (vol == 0)
    return 1;

  if (argc == 2)
    {
      fargv = hfs_glob(vol, 1, &argv[1], &fargc);
      if (fargv == 0)
	{
	  fprintf(stderr, "%s: out of memory\n", argv[0]);
	  result = 1;
	}
      else if (fargc != 1)
	{
	  fprintf(stderr, "%s: %s: ambiguous path\n", argv[0], argv[1]);
	  result = 1;
	}
      else
	path = fargv[0];
    }
  else
    {
      hfs_vstat(vol, &vent);

      strcpy(root, vent.name);
      strcat(root, ":");
      path = root;
    }

  if (result == 0)
    {
      if (hfs_chdir(vol, path) < 0)
	{
	  hfs_perrorp(path);
	  result = 1;
	}
      else
	{
	  path = hfs_cwd(vol);
	  if (path == 0)
	    {
	      hfs_perror("Can't get new HFS directory path");
	      result = 1;
	    }

	  if (result == 0 && hcwd_setcwd(ment, path) < 0)
	    {
	      perror("Can't set new HFS directory");
	      result = 1;
	    }

	  if (path)
	    free(path);
	}
    }

  if (hfs_umount(vol) < 0 && result == 0)
    {
      hfs_perror("Error closing HFS volume");
      result = 1;
    }

  if (fargv)
    free(fargv);

  return result;
}
