
/* Written by Peter Ekberg, peda@lysator.liu.se */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "thrust.h"

highscoreentry highscorelist[HIGHSCORES];

void
writehighscores(void)
{
  FILE *fp;

  fp=fopen(HIGHSCOREFILE, "wb");
  if(fp==NULL)
    return;
  fwrite(highscorelist, sizeof(highscoreentry), HIGHSCORES, fp);
  fclose(fp);
}

int
readhighscores(void)
{
  FILE *fp;
  int res;

  fp=fopen(HIGHSCOREFILE, "rb");
  if(fp==NULL)
    return(0);
  res = fread(highscorelist, sizeof(highscoreentry), HIGHSCORES, fp);
  if(res != HIGHSCORES)
    return(0);
  fclose(fp);

  return(1);
}

char *
standardname(void)
{
  char *tmp;
  static char name[40];
  int i;

  tmp=getenv("USER");
  if(tmp==NULL)
    tmp=getenv("LOGNAME");
  if(tmp==NULL)
    name[0]=0;
  else {
    strncpy(name, tmp, 39);
    name[39]=0;
    for(i=0; i<strlen(name); i++)
      name[i]=toupper(name[i]);
  }

  return(name);
}

int
inithighscorelist(void)
{
  int i;
  
  if(!readhighscores()) {
    for(i=0; i<HIGHSCORES; i++) {
      strcpy(highscorelist[i].name, "JOHN DOE");
      highscorelist[i].score=(5-i)*1000;
    }
  }
  
  return(0);
}

int
ahighscore(int score)
{
  return(score>highscorelist[HIGHSCORES-1].score);
}

void
inserthighscore(char *name, int score)
{
  int i;

  for(i=HIGHSCORES; i>0 && score>highscorelist[i-1].score; i--) {
    if(i<HIGHSCORES) {
      strcpy(highscorelist[i].name, highscorelist[i-1].name);
      highscorelist[i].score = highscorelist[i-1].score;
    }
  }
  if(i<HIGHSCORES) {
    strcpy(highscorelist[i].name, name);
    highscorelist[i].score = score;
  }
}
