/* e_model.cc		-*- C++ -*-
 *$Header: /al/acs/src/RCS/e_model.cc,v 9.9 95/06/08 20:12:46 al Exp $
 * base class for all models
 */
#include "ap.h"
#include "error.h"
#include "e_model.h"
#include "d_diode.h"
/*--------------------------------------------------------------------------*/
//	const MODEL_BASE* find_model(const char* name)const;
/*--------------------------------------------------------------------------*/
static MODEL_DIODE modeldummy("-error-");
MODEL_BASE* MODEL_BASE::rootmodel = &modeldummy;
/*--------------------------------------------------------------------------*/
MODEL_BASE::MODEL_BASE(const char *name)
{
  devclass = NOTDEVICE;
  strncpy(label, name, LABELEN);
  label[LABELEN] = '\0';
  stprev = rootmodel;
}
/*--------------------------------------------------------------------------*/
/* find_model: look for a model, knowing its type
 * looks only in list of same type
 * return ptr to it, throw exception if it fails.
 */
const MODEL_BASE* 
MODEL_BASE::find_model(const char* name)const
{
  const MODEL_BASE* brh;
  brh = this;	
  for (;;){
    brh = (MODEL_BASE*)brh->stnext;
    if (brh == this){
      error(bERROR, "can't find model: %s\n", name);
      return NULL;			/* didn't find it */
    }else if (wmatch(brh->label, name)){
      return brh;			/* found it */
    }
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
