;;;
;;; tm-mule.el --- tm definitions depended on Mule
;;;
;;; Copyright (C) 1995 Free Software Foundation, Inc.
;;; Copyright (C) 1994 .. 1996 MORIOKA Tomohiko
;;;
;;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;;; Version:
;;;	$Id: tm-mule.el,v 7.8 1996/02/12 16:02:05 morioka Exp $
;;; Keywords: mail, news, MIME, multimedia, multilingual, encoded-word
;;;
;;; This file is part of tm (Tools for MIME).
;;;
;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or
;;; (at your option) any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with This program.  If not, write to the Free Software
;;; Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
;;;
;;; Code:

(require 'emu)
(require 'tl-list)


;;; @ coding-system
;;;

(defvar mime/charset-coding-system-alist
  '(("ISO-2022-JP"     . *iso-2022-ss2-7*)
    ("ISO-2022-JP-2"   . *iso-2022-ss2-7*)
    ("X-ISO-2022-JP-2" . *iso-2022-ss2-7*)
    ("ISO-2022-CN"     . *iso-2022-ss2-7*)
    ("ISO-2022-KR"     . *iso-2022-kr*)
    ("EUC-KR"          . *euc-kr*)
    ("ISO-8859-1"      . *ctext*)
    ("ISO-8859-2"      . *iso-8859-2*)
    ("ISO-8859-3"      . *iso-8859-3*)
    ("ISO-8859-4"      . *iso-8859-4*)
    ("ISO-8859-5"      . *iso-8859-5*)
    ("ISO-8859-7"      . *iso-8859-7*)
    ("ISO-8859-8"      . *iso-8859-8*)
    ("ISO-8859-9"      . *iso-8859-9*)
    ("ISO-2022-INT-1"  . *iso-2022-int-1*)
    ("SHIFT_JIS"       . *sjis*)
    ("X-SHIFTJIS"      . *sjis*)
    ))


;;; @ leading-character and charset
;;;

(defvar mime/lc-charset-alist
  (list
   (cons (list lc-ascii)         "US-ASCII")
   (cons (list lc-ascii lc-ltn1) "ISO-8859-1")
   (cons (list lc-ascii lc-ltn2) "ISO-8859-2")
   (cons (list lc-ascii lc-ltn3) "ISO-8859-3")
   (cons (list lc-ascii lc-ltn4) "ISO-8859-4")
;;;(cons (list lc-ascii lc-crl)  "ISO-8859-5")
   (cons (list lc-ascii lc-crl)  "KOI8-R")
   (cons (list lc-ascii lc-grk)  "ISO-8859-7")
   (cons (list lc-ascii lc-hbw)  "ISO-8859-8")
   (cons (list lc-ascii lc-ltn5) "ISO-8859-9")
   (cons (list lc-ascii lc-jp)   "ISO-2022-JP")
   (cons (list lc-ascii lc-kr)   "EUC-KR")
   (cons (list lc-ascii
	       lc-jp lc-cn
	       lc-kr lc-jp2
	       lc-ltn1 lc-grk) "ISO-2022-JP-2")
   (cons (list lc-ascii
	       lc-jp lc-cn
	       lc-kr lc-jp2
	       lc-cns1 lc-cns2
	       lc-ltn1 lc-grk) "ISO-2022-INT-1")
   ))

(defvar mime/unknown-charset "ISO-2022-INT-1")


;;; @ functions
;;;

(defun mime/convert-string-to-emacs (charset str)
  (let ((cs (cdr (assoc charset mime/charset-coding-system-alist))))
    (if cs
	(code-convert-string str cs *internal*)
      )))

(defun mime/convert-string-from-emacs (str charset)
  (let ((cs (cdr (assoc charset mime/charset-coding-system-alist))))
    (if cs
	(code-convert-string str *internal* cs)
      )))

(defun mime/code-convert-region-to-emacs (beg end charset &optional encoding)
  (if (stringp charset)
      (progn
	(setq charset (upcase charset))
	(let ((ct (cdr (assoc charset mime/charset-coding-system-alist))))
	  (if ct
	      (code-convert beg end ct *internal*)
	    )))
    (if mime/default-coding-system
	(code-convert beg end mime/default-coding-system *internal*)
      )))


;;; @ end
;;;

(provide 'tm-mule)

(run-hooks 'tm-mule-load-hook)

;;; tm-mule.el ends here
