// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1995
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        timerman.h
// 
// Purpose:     decouple timer events and Dispatcher
// 
// Created:     28 Mar 96   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: timerman.h,v 1.2 1997/02/12 23:13:11 jfasch Exp $
// 
// $Log: timerman.h,v $
// Revision 1.2  1997/02/12 23:13:11  jfasch
// moved from HgDcCommon
//
// Revision 1.1  1996/05/23 14:47:05  jfasch
// Initial revision
//
// 
// </file> 
#ifndef hg_dispatch_timerman_h
#define hg_dispatch_timerman_h

class TimerHandler ;

class TimerManager {
public:
   static TimerManager& instance() ;

   void startTimer (long sec, long usec, TimerHandler*) ;
   void stopTimer (TimerHandler*) ;

private:
   TimerManager() ;

private:
   static TimerManager* instance_ ;

   friend class THandler ;
   class THandlerList* handlers_ ;
   void remove_handler_(class THandler*) ;
} ;

#endif
