#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <locale.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "express.h"
#include "bwindow.h"
#include "menus.h"
#include "options.h"
#include "url.h"

#ifdef FORK_DOWNLOAD
#include "msq.h"
#endif


int main(int argc, char *argv[])
{
   GtkWidget *bwindow;

   char *url;

   gtk_init(&argc, &argv);
   
   if(argc>1) {
     url = argv[1];
   } else {
     url = DEFAULT_HOME_URL;
   }

  express_init_app_kernel();

#if 0
   bwindow = bwindow_new();

   gtk_widget_show(bwindow);
#endif

   bwindow = express_new_browser();
   
#ifdef FORK_DOWNLOAD
   msq_rcv_init();
   gtk_idle_add(GTK_SIGNAL_FUNC(msq_rcv_check), bwindow);
#endif

   bwindow_set_url(BWINDOW(bwindow), url);


   /*g_print("locale: %s\n", setlocale(LC_ALL, NULL));*/

   gtk_main();
   
   cleanexit(0);

   return 0;
}
