/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 */

#include <fcntl.h>

int writeconfigfile(void)
{
	FILE *configfilehandle;
	struct devinfo *thisdev;	
	const char configfilename[]="/etc/powertweak.config";
	const char Comment_header[]="# Powertweak configuration file.\n\
# Automatically generated by Powertweak-config\n\
# Do NOT edit, unless you know what you are doing!\n\n";
	const char PCI_header[]="#[PCI]\n";

	configfilehandle=(fopen(configfilename, "w"));
	if (configfilehandle==NULL)
		return (FALSE);

	/* Save the header. */
	fprintf(configfilehandle, "%s%s", Comment_header, PCI_header);

	/* Now save the settings */
	thisdev = known_devlist;

	while (thisdev->vendor != 0) {
		dev=pacc->devices;
		while (dev) {
			if ((thisdev->vendor == dev->vendor_id) &&
				 (thisdev->device == dev->device_id) &&
				 (thisdev->save_func != 0)) {
				thisdev->save_func(configfilehandle, dev);
			}
			dev=dev->next;
		}
		thisdev++;
	}

	/* Close file, and clean up. */
    fclose(configfilehandle);
	return (TRUE);
}


void savefunction (GtkWidget *widget, gpointer gdata)
{
	char error_message[]="Error trying to save to /etc/powertweak.config !";
	char saved_message[]="Configuration file saved to /etc/powertweak.config";

	if (writeconfigfile()==FALSE)
		show_popup ("Error!", error_message);
	else
		show_popup ("Done.", saved_message);
}


void write_tweaks(FILE *savehandle,
				unsigned int numtweaks,
				Tweaks_t *tweaks,
				struct pci_dev *current_dev)
{
	char name_buffer[256];
	unsigned int i;

	pci_lookup_name(pacc, name_buffer, sizeof(name_buffer),
					PCI_LOOKUP_VENDOR|PCI_LOOKUP_DEVICE,
					current_dev->vendor_id, current_dev->device_id, 0, 0);
	
	fprintf(savehandle, "\n#%s\n", name_buffer);
	for (i=0;i<numtweaks;i++) {
		if (tweaks->current_value == TRUE)
			fprintf (savehandle, "%.4x%.4x_%s\n", current_dev->vendor_id, current_dev->device_id, tweaks->tagname);
		else
			fprintf (savehandle, "#%.4x%.4x_%s\n", current_dev->vendor_id, current_dev->device_id, tweaks->tagname);
		tweaks++;
	}
}


void init_configfile(void)
{
	struct devinfo *thisdev;	

	thisdev = known_devlist;

	while (thisdev->vendor != 0) {
		dev=pacc->devices;
		while (dev) {
			if ((thisdev->vendor == dev->vendor_id) &&
				 (thisdev->device == dev->device_id) &&
				 (thisdev->save_func != 0)) {
				thisdev->init_func(dev);
			}
			dev=dev->next;
		}
		thisdev++;
	}
}


void init_tweaks(unsigned int numtweaks, Tweaks_t *tweaks, struct pci_dev *current_dev)
{
	unsigned int i;

	for (i=0;i<numtweaks;i++) {
		if ((pci_read_byte (current_dev, tweaks->reg) & tweaks->mask) == tweaks->value)
			tweaks->original_value=TRUE;
		else
			tweaks->original_value=FALSE;
		tweaks->current_value = tweaks->original_value;
		tweaks++;
	}
}
