/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 */

#include "decode_bios.c"
#include "decode_pins.c"
#include "scan-lfb.c"

#include <fcntl.h>

#define VIDEO_BIOS_START 0x000C0000L
#define VIDEO_BIOS_END   0x000C8000L
#define VIDEO_BIOS_SIZE VIDEO_BIOS_END-VIDEO_BIOS_START

#define PCI_DEVICE_ID_MATROX_G200 0x0521

void Show_G200_info (GtkWidget *notebook, struct pci_dev *current_pci_dev)
{
	char TextBuffer[2048];
	char *TextPtr;
	GtkText *InfoTextPtr;

	int pinsoffset;

	unsigned char buf[VIDEO_BIOS_SIZE];
	unsigned char *memptr;
	int fd, i;
	long fp;
	char namebuf[128];
	LFB LFB_table[5];
	int num_of_LFBs;

	TextPtr=TextBuffer;

/* Read data from the video BIOS. */

	fd=open("/dev/mem", O_RDONLY);
	fp=VIDEO_BIOS_START;

	memptr = buf;

	if(fd==-1) {
		perror("/dev/mem");
		exit(1);
	}
	if(lseek(fd,fp,0)==-1) {
		perror("seek");
		exit(1);
	}
		
	if (read(fd, buf, VIDEO_BIOS_SIZE) !=VIDEO_BIOS_SIZE)
		perror("Read");

	if (*memptr!=0x55 && *memptr+1!=0xAA) {
		perror("Video BIOS not found.\n");
		exit(1);
	}

	pinsoffset = decode_biosarea(&TextPtr, memptr);
	decode_pins(&TextPtr, pinsoffset, memptr);

	num_of_LFBs = getLFB(LFB_table, current_pci_dev);
	if (num_of_LFBs!=0) {
		TextPtr+=sprintf (TextPtr, "Found %d LFBs\n", num_of_LFBs);
		for (i=0;i<num_of_LFBs;i++) {
			TextPtr+=sprintf(TextPtr, "\tbase:%lx\tmask:%lx\n", LFB_table[0].base, LFB_table[0].mask);
		}
	}
	close(fd);


	AddPage (GTK_NOTEBOOK(notebook), "Extended info");
	InfoTextPtr = CreateText(TextBuffer);
	gtk_container_add (GTK_CONTAINER (current_pages[current_max_page-1]), GTK_WIDGET(InfoTextPtr));
}
