/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 */

void show_CPU_info_AMD(void)
{
	GtkWidget *vbox;
	GtkWidget *ID_frame, *Cache_frame;
	GtkWidget *ID_listbox, *Cache_listbox, *item;
	GtkText *InfoTextPtr;
	GtkWidget *scrolled_win;

	char *strValue[2];

	char TextBuffer[1024];
	char *TextPtr;

	char *CacheTitles[]= {"Name", "Value"};


	remove_all_pages(notebook);

/*
 ************
  Page 1: "Information"
 ************
 */

	vbox = gtk_vbox_new(FALSE, 0);

	ID_frame = gtk_frame_new("ID:");
	gtk_box_pack_start (GTK_BOX(vbox), ID_frame, FALSE, FALSE, 0);
	gtk_widget_show(ID_frame);

	ID_listbox = gtk_clist_new(2);
	gtk_clist_set_column_width (GTK_CLIST (ID_listbox), 0, 80);
	gtk_clist_set_column_width (GTK_CLIST (ID_listbox), 1, 80);
	gtk_clist_set_column_justification (GTK_CLIST (ID_listbox),	0, GTK_JUSTIFY_LEFT);
	gtk_clist_set_column_justification (GTK_CLIST (ID_listbox), 1, GTK_JUSTIFY_LEFT);
	gtk_clist_set_selection_mode (GTK_CLIST (ID_listbox), GTK_SELECTION_BROWSE);

	strValue[0] = g_strdup_printf("Vendor:");
	strValue[1] = g_strdup_printf("AMD");
	(void *)item = gtk_clist_append(GTK_CLIST (ID_listbox), strValue);

	strValue[0] = g_strdup_printf("Family:");
	switch (cpu0_data.family) {

		case 4:
			strValue[1] = g_strdup_printf("Am486/AM5x86");
			break;

		case 5:
			switch (cpu0_data.model) {
				case 0 ... 3 :		strValue[1] = g_strdup_printf("K5");
									break;
				case 4 ... 7 :		strValue[1] = g_strdup_printf("K6");
									break;
				case 8 :			strValue[1] = g_strdup_printf("K6-2");
									break;
				case 9 :			strValue[1] = g_strdup_printf("K6-3");
									break;
			}
			break;

		case 6:
			strValue[1] = g_strdup_printf("K7 Athlon");
			break;

		default:
			strValue[1] = g_strdup_printf("Unknown");
			break;
	}
	(void *)item = gtk_clist_append(GTK_CLIST (ID_listbox), strValue);

	strValue[0] = g_strdup_printf("Model:");
	strValue[1] = g_strdup_printf("%x", cpu0_data.model);
	(void *)item = gtk_clist_append(GTK_CLIST (ID_listbox), strValue);

	strValue[0] = g_strdup_printf("Stepping:");
	strValue[1] = g_strdup_printf("%x", cpu0_data.stepping);
	(void *)item = gtk_clist_append(GTK_CLIST (ID_listbox), strValue);

	gtk_widget_show_all (ID_listbox);
	gtk_container_add (GTK_CONTAINER (ID_frame), ID_listbox);


	if (((cpu0_data.family ==5) && (cpu0_data.model>=1)) ||
		((cpu0_data.family ==6))) {

		/*
		 * Cache Info frame
		 */
		Cache_frame = gtk_frame_new("Cache:");
		scrolled_win = gtk_scrolled_window_new(NULL, NULL);
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
				GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		gtk_container_add (GTK_CONTAINER (Cache_frame), scrolled_win);

		
		Cache_listbox = gtk_clist_new_with_titles(2, CacheTitles);
		gtk_clist_set_column_width (GTK_CLIST (Cache_listbox), 0, 120);
		gtk_clist_set_column_width (GTK_CLIST (Cache_listbox), 1, 80);
		gtk_clist_set_column_justification (GTK_CLIST (Cache_listbox), 0, GTK_JUSTIFY_LEFT);
		gtk_clist_set_column_justification (GTK_CLIST (Cache_listbox), 1, GTK_JUSTIFY_LEFT);
		gtk_clist_set_selection_mode (GTK_CLIST (Cache_listbox), GTK_SELECTION_BROWSE);

		strValue[0] = g_strdup_printf("L1 Instruction TLB:");
		strValue[1] = g_strdup_printf("%d-way set associative", cpu0_data.ITLB_assoc);
		(void *)item = gtk_clist_append(GTK_CLIST (Cache_listbox), strValue);

		strValue[0] = g_strdup_printf(" ");
		strValue[1] = g_strdup_printf("%d entries", cpu0_data.ITLB_entries);
		(void *)item = gtk_clist_append(GTK_CLIST (Cache_listbox), strValue);

		strValue[0] = g_strdup_printf(" ");
		strValue[1] = g_strdup_printf(" ");
		(void *)item = gtk_clist_append(GTK_CLIST (Cache_listbox), strValue);

		strValue[0] = g_strdup_printf("L1 Data TLB:");
		strValue[1] = g_strdup_printf("%d way set associative", cpu0_data.DTLB_assoc);
		(void *)item = gtk_clist_append(GTK_CLIST (Cache_listbox), strValue);

		strValue[0] = g_strdup_printf(" ");
		strValue[1] = g_strdup_printf("%d entries", cpu0_data.DTLB_entries);
		(void *)item = gtk_clist_append(GTK_CLIST (Cache_listbox), strValue);

		strValue[0] = g_strdup_printf(" ");
		strValue[1] = g_strdup_printf(" ");
		(void *)item = gtk_clist_append(GTK_CLIST (Cache_listbox), strValue);

		strValue[0] = g_strdup_printf("L1 Instruction Cache:");
		strValue[1] = g_strdup_printf("%dKb cache size", cpu0_data.ICACHE_size);
		(void *)item = gtk_clist_append(GTK_CLIST (Cache_listbox), strValue);

		strValue[0] = g_strdup_printf(" ");
		strValue[1] = g_strdup_printf("%d way set associative", cpu0_data.ICACHE_assoc);
		(void *)item = gtk_clist_append(GTK_CLIST (Cache_listbox), strValue);

		strValue[0] = g_strdup_printf(" ");
		strValue[1] = g_strdup_printf("%d byte line size", cpu0_data.ICACHE_linesize);
		(void *)item = gtk_clist_append(GTK_CLIST (Cache_listbox), strValue);

		strValue[0] = g_strdup_printf(" ");
		strValue[1] = g_strdup_printf("%d line per tag", cpu0_data.ICACHE_linespertag);
		(void *)item = gtk_clist_append(GTK_CLIST (Cache_listbox), strValue);

		strValue[0] = g_strdup_printf(" ");
		strValue[1] = g_strdup_printf(" ");
		(void *)item = gtk_clist_append(GTK_CLIST (Cache_listbox), strValue);

		strValue[0] = g_strdup_printf("L1 Data Cache:");
		strValue[1] = g_strdup_printf("%dKb cache size", cpu0_data.DCACHE_size);
		(void *)item = gtk_clist_append(GTK_CLIST (Cache_listbox), strValue);

		strValue[0] = g_strdup_printf(" ");
		strValue[1] = g_strdup_printf("%d way set associative", cpu0_data.DCACHE_assoc);
		(void *)item = gtk_clist_append(GTK_CLIST (Cache_listbox), strValue);

		strValue[0] = g_strdup_printf(" ");
		strValue[1] = g_strdup_printf("%d byte line size", cpu0_data.DCACHE_linesize);
		(void *)item = gtk_clist_append(GTK_CLIST (Cache_listbox), strValue);

		strValue[0] = g_strdup_printf(" ");
		strValue[1] = g_strdup_printf("%d line per tag", cpu0_data.DCACHE_linespertag);
		(void *)item = gtk_clist_append(GTK_CLIST (Cache_listbox), strValue);

		gtk_clist_column_titles_show(GTK_CLIST (Cache_listbox));
		gtk_widget_show_all (Cache_listbox);
		gtk_container_add (GTK_CONTAINER (scrolled_win), Cache_listbox);
		gtk_widget_show (Cache_frame);
		gtk_widget_show (scrolled_win);
		gtk_box_pack_start (GTK_BOX (vbox), Cache_frame, TRUE, TRUE, 0);
	}

	gtk_widget_show (vbox);

	AddPage (GTK_NOTEBOOK(notebook), "Information");
	gtk_container_add (GTK_CONTAINER (current_pages[current_max_page-1]), vbox);

/*
 ************
  Page 2: "Features"
 ************
 */

	TextPtr = TextBuffer;
	get_features(TextPtr);
	AddPage (GTK_NOTEBOOK(notebook), "Features");
	InfoTextPtr = CreateText(TextPtr);
	gtk_container_add (GTK_CONTAINER (current_pages[current_max_page-1]),
						GTK_WIDGET(InfoTextPtr));
}
