/* main.c - MemTest-86  Version 2.2
 *
 * Copyright 1999,  Chris Brady
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without fee
 * is granted provided that the above copyright notice appears in all copies.
 * It is provided "as is" without express or implied warranty.
 */
#include "test.h"
#include "defs.h"
#undef TEST_TIMES

struct cpu_ident cpu_id;
struct tseq tseq[] = {
	{0, 0, 5, 3, "[Address test, walking ones, no cache]"},
	{1, 0, 0, 3, "[Moving inv, ones & zeros, cached]    "},
	{1, 1, 3, 2, "[Modulo 20, ones & zeros, cached]     "},
	{0, 0, 6, 3, "[Address test, own address, no cache]"},
	{1, 1, 1, 2, "[Moving inv, 8 bit pattern, cached]   "},
	{1, 1, 2, 2, "[Moving inv, 32 bit pattern, cached]  "},
	{0, 1, 0, 2, "[Moving inv, ones & zeros, no cache]  "},
	{1, 1, 3, 8, "[Modulo 20+, ones & zeros, cached]    "},

	{0, 2, 1, 2, "[Moving inv, 8 bit pattern, no cache] "},
	{1, 2, 4, 2, "[Modulo 20, 8 bit pattern , cached]   "},
	{0, 2, 2, 2, "[Moving inv, 32 bit pattern, no cache]"},
	{0, 0, 0, 0, NULL}
};

#ifdef UNIXTEST
#include <stdio.h>
#include <sys/mman.h>
#include <unistd.h>
#include <fcntl.h>
#undef START_ADR
#define START_ADR start_adr
#undef SCREEN_ADR
#define SCREEN_ADR screen_adr
#define MEMSZ 4096 /* test area size Kbytes */
char start_adr[MEMSZ*1024];
unsigned long screen_adr;
void do_test(void);
unsigned memsz;

int main ()
{
  int fd;
  memsz = (unsigned)start_adr/1024 + MEMSZ - 1024;
  fd = open("/dev/mem",O_RDWR);
  screen_adr = (unsigned)mmap(0,4096,PROT_READ|PROT_WRITE,MAP_SHARED,fd,0xb8000);
  close(fd);
  do_test();
}
#endif

unsigned long p1 = 0, p2 = 0, p0 = 0;
volatile long *p = 0, *pd = 0;
int segs = 0, bail = 0;
struct vars *v;

void do_test(void)
{
	int i = 0, j = 0;
	long a;

	/* Set pointer to common variable area */
	v = (struct vars *)(TESTADR+TSTSIZE-0x400);

	/* If first time, initialize test */
	if (v->firsttime == 0) {
		init();
		v->firsttime = 1;
	}
	for (i=0; i< v->msegs; i++) {
		if ((long)v->rmap[i].start >= v->lim_lower && 
			(long)v->rmap[i].end <= v->lim_upper) {
			v->map[i].v = 1;
			v->map[i].start = v->rmap[i].start;
			v->map[i].end = v->rmap[i].end;
		} else {
			if ((long)v->rmap[i].start < v->lim_lower) {
				if ((long)v->map[i].end < v->lim_lower) {
					v->map[i].v = 0;
				} else {
					v->map[i].start=(long *)v->lim_lower;
				}
			}
			if ((long)v->rmap[i].end > v->lim_upper) {
				if ((long)v->map[i].start < v->lim_upper) {
					v->map[i].end = (long *)v->lim_upper;
				} else {
					v->map[i].v = 0;
				}
			}
		}
	}

	/* Since all phases of the test have the same entry point we use
	 * the address of a static variable (segs) to know if the test code has
	 * been relocated.  */
	 if (&segs < (int *)RELOBASE) { 
		/* Not relocated */
		/* Set stack and idt */
		asm __volatile__ ("mov %0,%%esp" : : "a" (TESTADR));
		asm __volatile__ ("lidt %0" : : "m" (idt_descr));


		/* Update display of memory segments being tested */
		if ((long)v->map[0].start > v->lim_lower) {
			a = (long)v->map[0].start;
		} else {
			a = v->lim_lower;
		}
		aprint(LINE_RANGE, 9, a);
		cprint(LINE_RANGE, 14, " - ");
		aprint(LINE_RANGE, 17, v->lim_upper);
		cprint(LINE_RANGE, 23, "          ");
		segs = v->msegs;

#ifdef TEST_TIMES
		{
		long l, h, t;

		asm __volatile__ ("pushl %eax\n\tpushl %edx\n\t");

		asm __volatile__ ("rdtsc":"=a" (l),"=d" (h));
		asm __volatile__ ("subl %2,%0\n\t"
			"sbbl %3,%1"
			:"=a" (l), "=d" (h)
			:"g" (v->snapl), "g" (v->snaph),
			"0" (l), "1" (h));

		cprint(20, 5, ":  :");
		t = h * ((unsigned)0xffffffff / v->clks_msec) / 1000;
		t += (l / v->clks_msec) / 1000;
		i = t % 60;
		dprint(20, 10, i%10, 1, 0);
		dprint(20, 9, i/10, 1, 0);
		t /= 60;
		i = t % 60;
		dprint(20, +7, i % 10, 1, 0);
		dprint(20, +6, i / 10, 1, 0);
		t /= 60;
		dprint(20, 0, t, 5, 0);

		asm __volatile__ ("rdtsc":"=a" (v->snapl),"=d" (v->snaph));
		asm __volatile__ ("popl %edx\n\tpopl %eax\n\t");
		}
#endif
	} else {
		/* Relocated */
		/* Set stack and idt */
		asm __volatile__ ("mov %0,%%esp" : : "a" (TESTADR+RELOBASE));
		asm __volatile__ ("lidt %0" : : "m" (idt_descr));
		/* Set pointer to common variable area */
		v = (struct vars *)(RELOBASE+TESTADR+TSTSIZE-0x400);

		v->map[0].start = (volatile long *)v->lim_lower;
		if (SKIP_START < v->lim_upper) {
			v->map[0].end = (volatile long *)SKIP_START;
		} else {
			v->map[0].end = (volatile long *)v->lim_upper;
		}

		/* Update display of memory segments being tested */
		segs = 1;
		aprint(LINE_RANGE, 9, (long)v->map[0].start);
		cprint(LINE_RANGE, 14, " - ");
		aprint(LINE_RANGE, 17, (long)v->map[0].end);
		cprint(LINE_RANGE, 23, "Relocated");
	}

	/* Now setup the test parameters based on the current test number */
	/* Figure out the next test to run */
	if (v->testsel < 0) {
		switch(v->xtst_flag) {
		case 0: /* Default tests */
			if (v->test > DEFTESTS) {
				goto skip_test;
			}
			break;
		case 1: /* Extended tests */
			if (v->test <= DEFTESTS) {
				goto skip_test;
			}
			break;
		}
			
		/* May skip this test if the cache settings have been */
		/* overridden */
		if ((v->cache_flag == 1 && tseq[v->test].cache == 0) ||
			(v->cache_flag == 2 && tseq[v->test].cache == 1)) {
			goto skip_test;
		}
	} else {
		v->test = v->testsel;
	}
	dprint(LINE_TST, 9, v->test, 2, 1);
	cprint(LINE_TST, 11, tseq[v->test].msg);
	set_cache(tseq[v->test].cache);
	if (v->ref_flag == 0) {
		set_refresh(tseq[v->test].ref);
	}

	/* Now do the testing according to the selected pattern */
	bail = 0;
	switch(tseq[v->test].pat) {
	case 0:	/* Moving inversions, all ones and zeros */
		p1 = 0;
		p2 = ~p1;
		movinv1(tseq[v->test].iter,p1,p2);
		BAILOUT;
	
		/* Switch patterns */
		p2 = p1;
		p1 = ~p2;
		movinv1(tseq[v->test].iter,p1,p2);
		break;
		
	case 1: /* Moving inversions, 8 bit wide walking ones and zeros. */
		p0 = 0x80;
		for (i=0; i<8; i++, p0=p0>>1) {
			p1 = p0 | (p0<<8) | (p0<<16) | (p0<<24);
			p2 = ~p1;
			movinv1(tseq[v->test].iter,p1,p2);
			BAILOUT;
	
			/* Switch patterns */
			p2 = p1;
			p1 = ~p2;
			movinv1(tseq[v->test].iter,p1,p2);
			BAILOUT
		}
		break;

	case 2: /* Moving inversions, 32 bit shifting pattern, very long */
		for (i=0, p1=1; p1; p1=p1<<1, i++) {
			movinv32(tseq[v->test].iter,p1, 1, 0x80000000, 0, i);
			BAILOUT
			movinv32(tseq[v->test].iter,~p1, 0xfffffffe,
				0x7fffffff, 1, i);
			BAILOUT
		}
		break;

	case 3: /* Modulo X check, all ones and zeros */
		p1=0;
		for (i=0; i<MOD_SZ; i++) {
			p2 = ~p1;
			modtst(i, tseq[v->test].iter, p1, p2);
			BAILOUT

			/* Switch patterns */
			p2 = p1;
			p1 = ~p2;
			modtst(i, tseq[v->test].iter, p1,p2);
			BAILOUT
		}
		break;

	case 4: /* Modulo X check, 8 bit pattern */
		p0 = 0x80;
		for (j=0; j<8; j++, p0=p0>>1) {
			p1 = p0 | (p0<<8) | (p0<<16) | (p0<<24);
			for (i=0; i<MOD_SZ; i++) {
				p2 = ~p1;
				modtst(i, tseq[v->test].iter, p1, p2);
				BAILOUT

				/* Switch patterns */
				p2 = p1;
				p1 = ~p2;
				modtst(i, tseq[v->test].iter, p1, p2);
				BAILOUT
			}
			BAILOUT
		}
		break;
	case 5: /* Address test, walking ones */
		addr_tst1();
		break;

	case 6: /* Address test, own address */
		addr_tst2();
		break;
	}

	/* End of a test phase so relocate the test only if
	 * - we are not already relocated
	 * - there is more than 1 meg of memory
	 * - The lower limit is less than START_ADR */
	if (&segs < (int *)RELOBASE &&
			v->rmap[v->msegs-1].end > (long *)0x110000 &&
			v->lim_lower < START_ADR) {
		cprint(LINE_PAT, 17, "            ");

		/* Copy test code to high memory */
		p = (long *)TESTADR;
		pd = (long *)(RELOBASE+TESTADR);
		for (i=0; i<(TSTSIZE)/4; i++) {
			*pd = *p;
			p++;
			pd++;
		}

		/* Jump to relocated code */
		p = (long *)(RELOBASE+TESTADR+MAINSZ);
		goto *p;
	} else {
skip_test:
		v->test++;
		/* If this was the last test then we finished a pass */
		if (tseq[v->test].msg == NULL || v->testsel >= 0) {
			v->pass++;
			dprint(LINE_PASS, 72, v->pass, 6, 1);
			v->test = 0;
		}
		cprint(LINE_PAT, 17, "            ");

		/* If relocated, move back to low memory */
		if (&segs > (int *)RELOBASE) {
			/* Don't relocate if only low memory is being tested */
			if (v->lim_upper <= SKIP_START) {
				/* Jump to relocated code */
				p = (long *)(RELOBASE+TESTADR+MAINSZ);
				goto *p;
			}

			/* Copy test code to low memory */
			p = (long *)(RELOBASE+TESTADR);
			pd = (long *)TESTADR;
			for (i=0; i<(TSTSIZE)/4; i++) {
				*pd = *p;
				p++;
				pd++;
			}
		}

		/* Jump to test start */
		p = (long *)TESTADR;
		goto *p;
	}
}
