/* comlib/zprt -- howfar message control */

#pragma member softnet/zprt.h
#include <softnet/zprt.h>
#include <time.h>

/* ztodx -- send TOD stamp */
void
ztodx(void)
{
	time_t hour;
	time_t min;
	time_t sec;

	sec = ztodtime();

	hour = sec / (60 * 60);
	sec = sec % (60 * 60);
	min = sec / 60;
	sec = sec % 60;

	zprtx("%2.2d:%2.2d:%2.2d ",hour,min,sec);
}

/* zmsgvx -- output howfar */
/* RETURNS: length of output string */
int
zmsgvx(const char *fmt,va_list ap)
/* fmt -- format */
{
	int len;

	ztodx();
	len = zprtvx(0,fmt,ap);

	return len;
}

/* zmsgx -- output howfar */
/* RETURNS: length of output string */
int
zmsgx(const char *fmt,...)
/* fmt -- format */
{
	va_list ap;
	int len;

	va_start(ap,fmt);
	len = zmsgvx(fmt,ap);
	va_end(ap);

	return len;
}

/* zprtx -- output howfar to stxerr */
/* RETURNS: length of output string */
int
zprtx(const char *fmt,...)
/* fmt -- format */
{
	va_list ap;
	int len;

	va_start(ap,fmt);
	len = zprtvx(0,fmt,ap);
	va_end(ap);

	return len;
}
