/* softnet/zprtdef.h -- zprt definition control */

#define zprta(lvl,args) \
	if (zprtok(lvl)) \
		zprtx/**/args
#define zmsga(lvl,args) \
	if (zprtok(lvl)) \
		zmsgx/**/args

#ifdef HOWFAR
#define zprt(lvl,args)			zprta(lvl,args)
#else /*HOWFAR*/
#define zprt(lvl,args)			/**/
#endif /*HOWFAR*/

#ifdef HOWFAR
#define zmsg(lvl,args)			zmsga(lvl,args)
#else /*HOWFAR*/
#define zmsg(lvl,args)			/**/
#endif /*HOWFAR*/

/* execute an arbitrary command */
#ifdef HOWFAR
#define zprtexec(lvl,args) \
	if (zprtok(lvl)) \
		args
#else /*HOWFAR*/
#define zprtexec(lvl,args)		/**/
#endif /*HOWFAR*/

/* wait for GDB to catch up */
#ifdef HOWFAR
#ifndef zprtgdb
#define zprtgdb(lvl,args) \
	if (lvl) \
		zprtgdbx/**/args
#endif /*zprtgdb*/
#else /*HOWFAR*/
#ifdef zprtgdb
#undef zprtgdb
#endif /*zprtgdb*/
#define zprtgdb(lvl,args)		/**/
#endif /*HOWFAR*/

/* execute a dump command */
#define zdmp(lvl,opt,bf,bflen,reason) \
	zprtexec(lvl,zdmpx(opt,bf,bflen,reason))

#ifdef HOWFAR
#define zprt_enter(lvl,args) \
	if (zprtok(lvl)) \
		zprtx_enter/**/args
#else /*HOWFAR*/
#define zprt_enter(lvl,args)			/**/
#endif /*HOWFAR*/

#define _zprt_exit(lvl,boolflg,name,what,fmt,err) \
	zprtexec(lvl,if (boolflg) zprtx_exit(name ": " what " " #err "=" fmt,err))
#define zprt_exit(lvl,name,err) \
	_zprt_exit(lvl,1,name,"EXIT","%d",err)
#define zprt_exitx(lvl,name,err) \
	_zprt_exit(lvl,1,name,"EXIT","%8.8X",err)
