.TH GREP-DCTRL 1 2000-02-06 "Debian Project" "Debian user's manual"
\" Copyright (C) 1999, 2000 Antti-Juhani Kaijanaho  <gaia@iki.fi>
\" 
\" Permission is granted to make and distribute verbatim copies of
\" this manual provided the copyright notice and this permission notice
\" are preserved on all copies.
\" 
\" Permission is granted to copy and distribute modified versions of this
\" manual under the conditions for verbatim copying, provided that the
\" entire resulting derived work is distributed under the terms of a
\" permission notice identical to this one.
\" 
\" Permission is granted to copy and distribute translations of this
\" manual into another language, under the above conditions for modified
\" versions, except that this permission notice may be included in
\" translations approved by the authors of this manual instead of in
\" the original English.
\" 
.SH NAME
grep-dctrl \- grep Debian control files
.SH SYNOPSIS
.B grep-dctrl
[ options ]
pattern
[
.IR file " ..."
]
.sp
.B grep-dctrl
--copying | --help | --version | -ChV
.SH DESCRIPTION
The grep-dctrl program can answer such questions as 
.IR "What is the Debian package foo?" , 
.IR "Which version of the Debian package bar is now current?" ,
.IR "Which Debian packages does John Doe maintain?" ,
.I  "Which Debian packages are somehow related to the Scheme"
.IR " programming language?" ,
and with some help,
.IR "Who maintain the essential packages of a Debian system?" ,
given a useful input file.
.PP
It is a specialised grep program that is meant for processing any file
which has the general format of a Debian package control file, as
described in the Debian Packaging Manual.  These include the dpkg
available file, the dpkg status file, and the Packages files on a
distribution medium (such as a Debian CD-ROM or an FTP site carrying
Debian).
.PP
You must give a search pattern on the command line.  By default, the
search is a case-sensitive fixed substring match on each paragraph (in
other words, package record) in the input.  With suitable command-line
options, this can be changed: the search can be case-insensitive and
the pattern can be seen as an extended POSIX regular expression.  By
default, the full matching paragraphs are printed on the standard
output; specific fields can be selected for output with the -s option.
One can also restrict the search to the body of a particular field;
see the -F option.  You can also search for packages that don't match
a certain criteria; see the -v option.
.PP
After the search pattern comes zero or more file names.  If no file
names are specified, the file name is searched in configuration files.
The input file from the first program name \- input file association
with the correct program name is used.  The program names are matched
with the base form of the name of the current program (the 0'th
command line argument, if you will).  The file name "-" is taken to
mean the standard input stream.  The files are searched in order but
separately; they are
.B not
concatenated together.  In other words, the end of a file always
implies the end of the current paragraph.
.SH OPTIONS
.IP "-l LEVEL, --errorlevel=LEVEL"
Set debugging level to LEVEL.  LEVEL is one of "fatal", "important",
"informational" and "debug", but the last may not be available,
depending on the compile-time options.  These categories are given
here in order; every message that is emitted when "fatal" is in
effect, will be emitted in the "important" error level, and so on.
The default is "important".
.IP "-F FIELD, --field=FIELD"
Restrict pattern matching to FIELD.
.IP -P
Shorthand for "-FPackage".
.IP "-s FIELD,FIELD,...; --show-field=FIELD,FIELD,..."
Show only the body of these fields from the matching paragraphs.  The
field names must not include any colons or commas.  Commas are used to
delimit field names in the argument to this option.  The fields are
shown in the order given here.
.IP "-n, --no-field-names"
Suppress field names when showing specified fields, only their bodies
are shown.  Each field is printed in its original form without the
field name, the colon after it and any whitespace predecing the start
of the body.
.IP "-e, --eregex"
Regard the pattern as an extended POSIX regular expression
.IP "-r, --regex"
The pattern is a standard POSIX regular expression.
.IP "-i, --ignore-case"
Ignore case when looking for a match.
.IP "-v, --invert-match"
Instead of showing all the paragraphs that match, show those paragraphs
that do
.I not
match.
.IP "-c FNAME, --config-file=FNAME"
Use FNAME as the config file instead of the defaults.  The short
option "-c" is deprecated; use the long option "--config-file"
instead.
.B The meaning of "-c" will change in the future.
.IP "-X, --exact-match"
Do an exact match (as opposed to a substring match).
.IP "-V, --version"
Print out version information.
.IP "-C, --copying"
Print out the copyright license.  This produces much output; be sure
to redirect or pipe it somewhere (such as your favourite pager).
.IP "-h, --help"
Print out a help summary.
.SH EXAMPLES
The following example queries assume that the default configuration is
in effect.
.PP
The almost simplest use of this program is to print out the status or
available record of a package.  In this respect,
.B grep-dctrl
is like
.B "dpkg -s"
or
.BR "dpkg --print-avail".
To print out the status record of the package "mixal", do
.nf
% grep-status -PX mixal
.fi
and to get its available record, use
.nf
% grep-available -PX mixal
.fi
In fact, you can ask for the record of the "mixal" package
from any Debian control file.  Say, you have the Debian 2.2
CD-ROM's Packages file in the current directory; now you
can do a
.nf
% grep-dctrl -PX mixal Packages
.fi
.PP
But
.B grep-dctrl
can do more than just emulate
.BR dpkg .
It can more-or-less emulate
.BR apt-cache !
That program has a search feature that searches package descriptions.
But we can do that too:
.nf
% grep-available -F Description foo
.fi
searches for the string "foo" case-sensitively in the descriptions of
all available packages.  If you want case-insensitivity, use
.nf
% grep-available -F Description -i foo
.fi
Truth to be told,
.B apt-cache
searches package names, too.  We can separately search in the names;
to do so, do
.nf
% grep-available -F Package foo
.fi
or
.nf
% grep-available -P foo
.fi
which is pretty much the same thing.  Unfortunately
.B grep-dctrl
does not yet search in multiple fields at the same time (this will be
fixed in the future).
.PP
Here's one thing neither
.B dpkg
nor
.B apt-cache
do.  Search for a string in the whole status or available file (or
any Debian control file, for that matter) and print out all package
records where we have a match.  Try
.nf
% grep-available dpkg
.fi
sometime and watch how thoroughly
.B dpkg
has infiltrated Debian.
.PP
All the above queries were based on simple substring searches.
But
.B grep-dctrl
can handle regular expressions in the search pattern.  For example,
to see the status records of all packages with either "apt" or
"dpkg" in their names, use
.nf
% grep-status -P -e 'apt|dpkg'
.fi
.PP
Now that we have seen all these fine and dandy queries, you might
begin to wonder whether it is necessary to always see the whole
paragraph.  You may be, for example, interest only in the dependency
information of the packages involved.  Fine.  To show the depends
lines of all packages maintained by me, do a
.nf
% grep-available -F Maintainer -s Depends 'ajk@debian.org'
.fi
If you want to see the packages' names, too, use
.nf
% grep-available -F Maintainer -s Package,Depends \\
  'ajk@debian.org'
.fi
Note that there must be no spaces in the argument to the -s switch.
.PP
You can do more complex (conjunctive) queries by using the Unix
pipeline as a helper tool.  This is usually most useful when
you want to narrow down queries based on different patterns
and different fields.  For example, to see the list of packages
maintained by me and depending on libc6, do
.nf
% grep-available -F Maintainer -s Package,Depends \\
  'ajk@debian.org' | grep-dctrl -sDepends -s Package libc6
.fi
You can use other Unix filters to help you, too.  Ever wondered, who's
the most active Debian developer based on the number of source
packages being maintained?  Easy.  You just need to have a copy
of the most recent Sources file from any Debian mirror.
.nf
% grep-dctrl -n -s Maintainer '' Sources | sort |
  uniq -c | sort -nr
.fi
This example shows a neat trick: if you want to selectively
show only some field of
.I all
packages, just supply an empty pattern.
.PP
These examples cover a lot of typical uses of this utility, but not
all possible uses.  Use your imagination!  The building blocks are
there, and if something's missing, let me know.
.SH DIAGNOSTICS
These messages are emitted in log levels "fatal" and "important".
.IP "don't try setting the search field twice"
You can search only in one field now, so using -F many times does not
make sense.  You should remove one of the -F's on your command line.
.IP "you can only use -s once"
You must give all fields to show in one -s command.  Usually many -s's
are typos anyway, so heed this message: remove one of the -s's or
merge all of them into one -s.
.IP "no such log level"
The argument to -l was invalid.
.IP "field name exceeds maximum length"
The name of a field to be searched is restricted to 512 octets (where
one ASCII or ISO 8859-X character takes one octet).  Longer names
cannot be used.
.IP "output field spec exceeds maximum length"
The argument to -s was too long; it is restricted to 512 octets.
Longer arguments cannot be used.
.IP "too many output fields"
The argument to -s had too many field names in it.  This number is
limited to 256.
.IP "do not use both -e and -r options"
The pattern cannot be both a standard POSIX regular expression and an
extended POSIX regular expression at the same time.  You must use at
most one of the options -e and -r; using both does not make sense.
.IP "I'm broken - please report this to <gaia@iki.fi>"
An internal consistency check failed.  Please, report this bug.
.IP "a pattern is mandatory"
You must specify a pattern to be searched.
.IP "cannot find enough memory"
More memory was needed than was available.  This error may be
transient, that is, if you try again, all may go well.
.IP "don't know how to do an exact regex match"
Currently you cannot do exact match searches with regular expressions.
.IP "cannot suppress field names when showing whole paragraphs"
When you do not use the -s switch,
.B grep-dctrl
just passes the matching paragraphs through, not touching them any
way.  This means, for example, that you can only use -n when you use
-s.
.IP "need a file name to grep"
For some reason no file name is available.  This means that the configuration
file did not list a default file name for this name of the program, and no
file name was given on the command line.
.IP "syntax error: need a executable name"
There is a problem in the configuration file.  Look, and you shall find it.
.IP "syntax error: need an input file name"
There is a problem in the configuration file.  Look, and you shall find it.
.SH FILES
.IP SYSCONF/grep-dctrl.rc
See the next file.
.IP ~/.grep-dctrlrc
These files are the default configuration files for
.BR grep-dctrl .
The format is line-based, with `#' introducing a comment that lasts to
the end of the line.  Each line defines one association between a
program name and a default input file.  These two things are listed in
the line in order, separated by whitespace.  Empty lines are ignored.
.SH AUTHOR
The program and this manual page were written by Antti-Juhani
Kaijanaho <gaia@iki.fi>.
.SH "SEE ALSO"
Ian Jackson et alia: Debian Packaging Manual.  Published as the Debian
package packaging-manual.  Also available in the Debian website.  The
Debian project, 1998.
.PP
.BR apt-cache (1),
.BR dpkg (1),
.BR dpkg-awk (1),
.BR sgrep (1)
\" Local variables:
\" mode: nroff
\" End:

