/* $Id: compat.c,v 1.2 1997/04/13 05:51:35 dps Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#ifdef HAVE_CTYPE_H
#include <ctype.h>
#endif /* HAVE_CTYPE_H */
#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef HAVE_STRCASECMP
int strcasecmp(const char *s, const char *t)
{
    register unsigned char a,b;

    while (*s && *t)
    {
	a=tolower(*s);
	b=tolower(*t);
	if (a<b)
	    return -1;
	if (a>b)
	    return 1;
	s++;
	t++;
    }
    if (*s!='\0')
	return -1;
    if (*t!='\0')
	return 1;
    return 0;
}
#endif

#ifndef HAVE_STRNCASECMP
int strncasecmp(const char *s, const char *t, int n)
{
    register unsigned char a,b;

    while (*s && *t)
    {
	if (n--==0)
	    return 0;

	a=tolower(*s);
	b=tolower(*t);
	if (a<b)
	    return -1;
	if (a>b)
	    return 1;
	s++;
	t++;
    }
    if (*s!='\0')
	return -1;
    if (*t!='\0')
	return 1;
    return 0;
}
#endif

#ifndef HAVE_STRDUP
char *strdup(const char *s)
{
    char *t;
    t=malloc(strlen(s)+1);
    strcpy(t,s);

    return t;
}
#endif /* HAVE_STRDUP */

#ifdef __cplusplus
}
#endif
