#!/usr/bin/python 
#
#  whence.py - find executable in user's PATH (or not)
#
#  $Id: whence.py,v 1.3 1998/09/11 14:31:46 cg Exp $
#
#  SGMLtools - an SGML toolkit.
#  Copyright (C) 1998 Simon J. Davies (original idea)
#  Copyright (c) 1998 Evelyn Mitchell (python port) 
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

"""
NAME

    whence - locate executable in user's PATH

SYNOPSIS

    abs_path = whence("<command name>");

DESCRIPTION

    The library routine whence() searches each element defined in the
    PATH variable of the executing user to establish the location of a
    specified command.

    whence() first checks that the directory specified in the path
    element exists and then checks to see if an executable with the
    required name exists in this directory.

    If an executable is located then the absolute path of that executable
    is returned to the calling program. If no match is found then 'undef'
    is returned.

"""

import os
import string


def pathperm(path, real=None):
    """
    Returns a 3-tuple of booleans indicating whether the process has
    (read, write, execute) permission to the path.  A true value for
    the 'real' argument indicates the test should occur for the real
    id rather than the effective id.
    
    From a script by Jeff Bauer posted to comp.lang.python 1998-07-28
    """
    try:
	stat = os.stat(path)
    except Exception, e:
	return (0,0,0)

    if real is None:
	uid = os.geteuid()
	gid = os.getegid()
    else:
	uid = os.getuid()
	gid = os.getgid()

    if uid == 0:
	return (1, 1, 00010 & stat[0])
    if uid == stat[4]:
	return (00400 & stat[0], 00200 & stat[0], 00100 & stat[0])
    elif gid == stat[5]:
	return (00040 & stat[0], 00020 & stat[0], 00010 & stat[0])
    else:
	return (00040 & stat[0], 00020 & stat[0], 00010 & stat[0])
		

def isreadable(path, real=None):
    if (pathperm(path, real)[0] > 0):
	return 1
    else:
	return 0

def iswriteable(path, real=None):
    if (pathperm(path, real)[1] > 0):
	return 1
    else:
	return 0

def isexecutable(path, real=None):
    if (pathperm(path, real)[2] > 0):
	return 1
    else:
	return 0

def whence (prog_to_find):
    path_string = os.environ["PATH"]
    userpath = string.splitfields(path_string, ":")
	

    #
    #  Run through each element in PATH checking for prog_to_find
    #
    for path_element in userpath:
        if path_element == '':
	    continue
	if max(path_element) != "/":
	    path_element = path_element + "/"
	potential_abs_path = path_element   + prog_to_find
	if os.path.isdir(path_element) and isexecutable(potential_abs_path, 0):
	    return potential_abs_path

    #
    #  If we got here they there is no _executable_ prog_to_find 
    #  in PATH (doesn't mean there isn't a file with that name of course ;-)
    #
    return "undef"

#
#  Test Code (or an example of usage :-)
#
if __name__ == '__main__':
    result = whence("sed")
    print "sed is located in %s" % (result)
