/*
 * GUI right-click menu module
 *
 * Almost every callback function internally calls the related action routine
 * defined in actions.[ch].
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <gnome.h>
#include "gdiff.h"
#include "gui.h"
#include "rmenu.h"
#include "fileview.h"
#include "actions.h"


/* Private function declarations */
static void mode_change_cb(GtkWidget *w, gpointer data);
static void line_num_show_cb(GtkWidget *w, gpointer data);
static void go_dirview_cb(GtkWidget *w, gpointer data);
static void text_wrap_cb(GtkWidget *w, gpointer data);
static void edit_file_cb(GtkWidget *w, gpointer data);


/* Private variables */
/* The right-click menu definitions */
static GnomeUIInfo file_menu_popup[] = {
	{GNOME_APP_UI_ITEM, N_("_Pane mode"), NULL,
	 mode_change_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType)0, NULL},
	{GNOME_APP_UI_ITEM, N_("_Line number"), NULL,
	 line_num_show_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType)0, NULL},
	{GNOME_APP_UI_ITEM, N_("_Go directory view"), NULL,
	 go_dirview_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType)0, NULL},
	{GNOME_APP_UI_ITEM, N_("_Text wrap"), NULL,
	 text_wrap_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType)0, NULL},
	{GNOME_APP_UI_ITEM, N_("_Edit file"), NULL,
	 edit_file_cb, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType)0, NULL},
	GNOMEUIINFO_END
};


/**
 * rmenu_create:
 * Create right-click menu for the file view.
 **/
void
rmenu_create(GDiffFileViews *gfileviews)
{
	PaneMode pmode = gfileviews->pref.pane_mode;
	GtkWidget *menu;

	if (pmode == ONE_PANE) {
		menu = gnome_popup_menu_new(file_menu_popup);
		gnome_popup_menu_attach(menu, GTK_WIDGET(gfileviews->pane.one.text), gfileviews);
	} else {
		int n;
		for (n = 0; n < NUM_COMPARE_FILES; n++) {
			menu = gnome_popup_menu_new(file_menu_popup);
			gnome_popup_menu_attach(menu, GTK_WIDGET(gfileviews->pane.two.text[n]), gfileviews);
		}
	}
}


/* ---The followings are private functions--- */
/**
 * mode_change_cb:
 **/
static void
mode_change_cb(GtkWidget *w, gpointer data)
{
	GDiffFileViews *gfileviews = data;

	act_fv_mode_change(gfileviews, !gfileviews->pref.pane_mode);
}

/**
 * line_num_show_cb:
 **/
static void
line_num_show_cb(GtkWidget *w, gpointer data)
{
	GDiffFileViews *gfileviews = data;

	act_fv_linenum_show(gfileviews, !gfileviews->pref.show_line_num);
}

/**
 * go_dirview_cb:
 **/
static void
go_dirview_cb(GtkWidget *w, gpointer data)
{
	GDiffFileViews *gfileviews = data;

	act_fv_go_dirview(gfileviews);
}

/**
 * text_wrap_cb:
 **/
static void
text_wrap_cb(GtkWidget *w, gpointer data)
{
	GDiffFileViews *gfileviews = data;
	WhichFile n = (WhichFile)gtk_object_get_user_data(GTK_OBJECT(w));
	GtkText *text = gfileviews->pane.two.text[n];
	gboolean to_wrap;

	to_wrap = !text->line_wrap;
	act_fv_toggle_textwrap(gfileviews, to_wrap);
}

/*experimental*/
/**
 * edit_file_cb:
 **/
static void
edit_file_cb(GtkWidget *w, gpointer data)
{
	GDiffFileViews *gfileviews = data;
	DiffFiles *dfiles = gfileviews->dfiles;
	PaneMode pmode = gfileviews->pref.pane_mode;
	WhichFile n;
	const FileInfo *fi;
	char *filename; 

	if (pmode == ONE_PANE)
		n = FIRST_FILE;
	else
		n = (WhichFile)gtk_object_get_user_data(GTK_OBJECT(w));
	fi = dfiles_get_fileinfo(dfiles, n, FALSE);
	filename = fi->fname;

	act_fv_edit_file(gfileviews, filename);
}

