/*********************************************************************/
/*  bibView: Administration of BibTeX-Databases                      */
/*           (Verwaltung von BibTeX-Literaturdatenbanken)            */
/*                                                                   */
/*  Module:  gui_main.c                                              */
/*                                                                   */
/*             - Realize main application window                     */
/*             -                                                     */
/*                                                                   */
/*  Author:  Holger Martin,  martinh@informatik.tu-muenchen.de       */
/*           Peter M. Urban, urban@informatik.tu-muenchen.de         */
/*                                                                   */
/*  History:                                                         */
/*    11.22.91  PMU  created                                         */
/*    05.26.92       Version 1.0 released                            */
/*                                                                   */
/*  Copyright 1992 TU MUENCHEN                                       */
/*    See ./Copyright for complete rights and liability information. */
/*                                                                   */
/*********************************************************************/

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
/* #include <X11/bitmaps/xlogo16>
#include <X11/bitmaps/gray> */
#include "bibview.h"


/* imported global variables */
/* ------------------------- */
extern Widget topLevel;
extern Pixmap chkmarkPixmap;
extern Pixmap bvIconPixmap;


/* macros and definitions */
/* ---------------------- */

/* structure hold a menu entry */
typedef struct {
   String name;
   XtCallbackProc cb;
   Boolean *bool;
} menuEntry;


/* local function prototypes */
/* ------------------------- */
static void OptionsSelect(Widget w, XtPointer client_data, XtPointer garbage);
static void createMenu(String name, menuEntry item[], Widget *menu, Widget parent, Boolean isBool);

/* exported variables */
/* ------------------ */
Widget mainMenu, desktop;


/* local global variables */
/* ---------------------- */

/* Widgets for main window */
static Widget mwWin,
	      mwCommandBox,
	      mwFile,       mwFileMenu,
	      mwServices,   mwServicesMenu,
	      mwOptions,    mwOptionsMenu,
	      mwWindow,     mwWindowMenu,
	      mwHelp,       mwHelpMenu,
	      mwDesktop;


static menuEntry fileEntry[] = {
   { "line1", NULL,              NULL },
   { "item1", copNewCmd,         NULL },
   { "item2", copOpenCmd,        NULL },
   { "item3", csaCloseBibCmd,    NULL },
   { "item4", csaSaveBibCmd,     NULL },
   { "item5", csaSaveAsBibCmd,   NULL },
   { "line2", NULL,              NULL },
   { "item6", csaQuitBibviewCmd, NULL },
   { NULL,    NULL,              NULL }
};

static menuEntry servicesEntry[] = {
   { "line1", NULL,             NULL },
   { "item1", cseCheckBibCmd,   NULL },
   { "item2", cseCollateBibCmd, NULL },
   { "item3", cprPrintBibCmd,   NULL },
   { "item4", cseEditMacrosCmd, NULL },
   { "item5", cseLoadConfigCmd, NULL },
   { NULL,    NULL,             NULL }
};

static menuEntry optionsEntry[] = {
   { "line1", NULL, NULL },
   { "item1", cotOptionsControl,
	      &optionsStatus[OPT_BEEP_ON_ERROR] },
   { "item2", cotOptionsControl,
	      &optionsStatus[OPT_BACKUP_ON_SAVE] },
   { "item3", cotOptionIconOnDeskCmd, 
	      &optionsStatus[OPT_ICON_ON_DESKTOP] },
   { "item4", cotOptionsControl,
	      &optionsStatus[OPT_AUTO_CHECK_BIB] },
   { "item5", cotOptionsControl,
	      &optionsStatus[OPT_REQUIRED_FIELDS] },
   { "item6", cotOptionsControl,
	      &optionsStatus[OPT_IGNORE_CASE] },
   { "item7", cotOptionsControl,
	      &optionsStatus[OPT_PRINT_AS_BIB] },
   { "item8", cotOptionsControl,
	      &optionsStatus[OPT_DISPLAY_ERRWIN] },
   { NULL, NULL, NULL }
};

static menuEntry windowEntry[] = {
   { "line1", NULL, NULL },
   { "item1", gubCascadeCmd, NULL },
   { NULL, NULL, NULL }
};

static menuEntry helpEntry[] = {
   { "line1", NULL, NULL },
   { "item1", hlpOpenHelpWinCmd, NULL },
   { "item2", hlpOpenHelpWinCmd, NULL },
   { "item3", hlpOpenHelpWinCmd, NULL },
   { "item4", hlpOpenHelpWinCmd, NULL },
   { "item5", hlpOpenHelpWinCmd, NULL },
   { "item6", hlpOpenHelpWinCmd, NULL },
   { "line2", NULL, NULL },
   { "info",  guwProgInfo, NULL },
   { NULL, NULL, NULL }
};



/*********************************************************************/
/* gwmMainWin:                                                       */
/*    Realize main application window                                */
/*********************************************************************/
int
gwmMainWin (void)
{
   mwWin        = XtVaCreateManagedWidget("mainwin", 
		    panedWidgetClass, topLevel, NULL);

   /* create command buttons */
   mainMenu =
   mwCommandBox = XtVaCreateManagedWidget("commandBox", 
		    boxWidgetClass, mwWin, NULL);
   mwFile       = XtVaCreateManagedWidget("file", 
		    menuButtonWidgetClass, mwCommandBox, NULL);
   mwServices   = XtVaCreateManagedWidget("services", 
		    menuButtonWidgetClass, mwCommandBox, NULL);
   mwOptions    = XtVaCreateManagedWidget("options", 
		    menuButtonWidgetClass, mwCommandBox, NULL);
   mwWindow     = XtVaCreateManagedWidget("window", 
		    menuButtonWidgetClass, mwCommandBox, NULL);
   mwHelp       = XtVaCreateManagedWidget("help", 
		    menuButtonWidgetClass, mwCommandBox, NULL);

   /* make pulldownmenus for command boxes */
   createMenu("fileMenu", fileEntry, &mwFileMenu, mwFile, FALSE);
   createMenu("servicesMenu", servicesEntry, &mwServicesMenu, mwServices, FALSE);
   createMenu("optionsMenu", optionsEntry, &mwOptionsMenu, mwOptions, TRUE);
   createMenu("windowMenu", windowEntry, &mwWindowMenu, mwWindow, FALSE);
   createMenu("helpMenu", helpEntry, &mwHelpMenu, mwHelp, FALSE);

   desktop = 
   mwDesktop    = XtVaCreateManagedWidget("desktop", 
                    formWidgetClass, mwWin,
		    XtNresizable, TRUE, NULL);
   return(OK);
}



/*********************************************************************/
/* createMenu:                                                       */
/*    Build a main application window pulldown menu                  */
/*********************************************************************/
static void
createMenu (String menuName, menuEntry item[], Widget *menu, Widget parent, Boolean isBool)
{
static Widget w;
int i = 0;
String iname;

   *menu = XtVaCreatePopupShell(menuName, 
                               simpleMenuWidgetClass, 
			       parent, NULL);
   i = 0;
   while ((iname = item[i].name) != NULL) { 
      if (strncmp("line", iname, 4) == 0)   /* use a line pane */
         w = XtVaCreateManagedWidget(iname,
               smeLineObjectClass, *menu, NULL);
      else {
         w = XtVaCreateManagedWidget(iname, 
	       smeBSBObjectClass, *menu, NULL);
	 if (isBool) {
	    if (*item[i].bool)
	       XtVaSetValues(w, XtNleftBitmap, chkmarkPixmap, NULL);
	 }
         XtAddCallback(w, XtNcallback, item[i].cb, (XtPointer) i);
      }
      i++;
   } /* endwhile */
}




