/*********************************************************************/
/*  bibView: Administration of BibTeX-Databases                      */
/*           (Verwaltung von BibTeX-Literaturdatenbanken)            */
/*                                                                   */
/*  Module:  ctl_opt.c                                               */
/*                                                                   */
/*             Options Control                                       */
/*             -                                                     */
/*                                                                   */
/*  Author:  Holger Martin,  martinh@informatik.tu-muenchen.de       */
/*           Peter M. Urban, urban@informatik.tu-muenchen.de         */
/*                                                                   */
/*  History:                                                         */
/*    12.08.91  PMU  created                                         */
/*    05.26.92       Version 1.0 released                            */
/*                                                                   */
/*  Copyright 1992 TU MUENCHEN                                       */
/*    See ./Copyright for complete rights and liability information. */
/*                                                                   */
/*********************************************************************/

#define COT_OPT

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include "bibview.h"


/* imported global variables */
/* ------------------------- */
extern Widget topLevel;
extern Pixmap chkmarkPixmap;


/* macros and definitions */
/* ---------------------- */


/* local function prototypes */
/* ------------------------- */


/* exported variables */
/* ------------------ */
Boolean optionsStatus[OPT_MAX_OPTION] = {
   FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, TRUE, FALSE, TRUE, TRUE 
};


/* local global variables */
/* ---------------------- */


/*********************************************************************/
/* cotOptionIconOnDeskCmd:                                           */
/*    Callback function for menu entry "icon on desktop"             */
/*********************************************************************/
void 
cotOptionIconOnDeskCmd (Widget w, XtPointer clientData, XtPointer callData)
{
BibPtr bp;
 
   if (optionsStatus[OPT_ICON_ON_DESKTOP]) { 
      /* reset: icons under wm control */
      XtVaSetValues(w, XtNleftBitmap, None, NULL);
      gubUnsetIconCoords(FALSE);
      bp = glbFirstBibListEl();
      while (bp != NULL) {
	 gulUnsetIconCoords(bp, FALSE);
	 gueUnsetIconCoords(bp, FALSE);
	 bp = glbNextBibListEl(bp);
      }  /* endwhile */
   }
   else { 
      /* set: icons under bibview control */
      XtVaSetValues(w, XtNleftBitmap, chkmarkPixmap, NULL);
      gubSetWindowCoords(TRUE);
      gubSetIconCoords(FALSE);
      bp = glbFirstBibListEl();
      while (bp != NULL) {
	 gulSetIconCoords(bp, FALSE);
	 gueSetIconCoords(bp, FALSE);
	 bp = glbNextBibListEl(bp);
      }  /* endwhile */
   }
   optionsStatus[OPT_ICON_ON_DESKTOP] = !optionsStatus[OPT_ICON_ON_DESKTOP];
}


/*********************************************************************/
/* cotOptionsControl:                                                */
/*    Callback function for all option menu entries                  */
/*********************************************************************/
void 
cotOptionsControl (Widget w, XtPointer client_data, XtPointer call_data)
{
int pane_num = (int) client_data;

   if (optionsStatus[pane_num]) 
      XtVaSetValues(w, 
                XtNleftBitmap, None,
                NULL);
    else 
        XtVaSetValues(w, 
                XtNleftBitmap, chkmarkPixmap,
                NULL);
    optionsStatus[pane_num] = !optionsStatus[pane_num];
}


