/**************************************************************************** 
** File: sip.c
**
** Author: Mike Borella
**
** Comments: Dump SIP header information. I didn't try to do anything
** fancy with this - I just dump the plaintext headers.  This makes 
** debugging easier since parsing is such a pain to get right.
**
*****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include "config.h"

#define LINE_SIZE 256
#define FALSE 0
#define TRUE  1

extern u_char *packet_end;

/*----------------------------------------------------------------------------
**
** dump_sip()
**
** Parse SIP packet and dump fields.  This code is kludgy - I'll fix it later
**
**----------------------------------------------------------------------------
*/

void dump_sip(u_char *bp, int length)
{
  u_char *ep = bp + length;
  u_char *p;
  u_char *ptr;
  char line[LINE_SIZE];
  int use_sdp = FALSE;
  int i;
  int n = 0;
  int get_next_line(u_char *, u_char *, char *);
  void dump_sdp(u_char *, int);


  /*
   * Make sure we don't run off the end of the packet
   */

  if (ep > packet_end) 
    ep = packet_end;

  p = bp;

  printf("-----------------------------------------------------------------\n");
  printf("                        SIP Headers\n");
  printf("-----------------------------------------------------------------\n");
  
  while(p <= ep && (n = get_next_line(p, ep, line)))
    {
      p = p + n;
      length = length - n;

      printf("Header:                 %s\n", line);

      for (i=0; i<strlen(line); i++)
	line[i] = tolower(line[i]);

      if (!strncmp("content-type", line, 12))
	{
	  ptr = &line[14];
	  while(isspace(*ptr)) 
	    ptr++;

	  if (!strncmp("application/sdp", ptr, 15))
	    use_sdp = TRUE;
	}
      
    }
  
  p = p + 2;

  if (use_sdp)
    dump_sdp(p, length);
}

