/**************************************************************************** 
** File: sdp.c
**
** Author: Mike Borella
**
** Comments: Dump SDP header information. Like SIP, we just dump the 
** Header contents in plaintext.
**
** Maybe we'll try to "decode" these headers into something intelligble 
** later...
**
*****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include "config.h"

#define LINE_SIZE 256

extern u_char *packet_end;

/*----------------------------------------------------------------------------
**
** dump_sdp()
**
** Parse SDP and dump fields
**
**----------------------------------------------------------------------------
*/

void dump_sdp(u_char *bp, int length)
{
  u_char *ep = bp + length;
  u_char *p;
  char line[LINE_SIZE];
  int n = 0;
  int get_next_line(u_char *, u_char *, char *);


  /*
   * Make sure we don't run off the end of the packet
   */

  if (ep > packet_end) 
    ep = packet_end;

  p = bp;

  printf("-----------------------------------------------------------------\n");
  printf("                        SDP Headers\n");
  printf("-----------------------------------------------------------------\n");
  
  while(p <= ep && (n = get_next_line(p, ep, line)))
    {
      p = p + n;
      printf("Header:                 %s\n", line);
    }  
}

