/**************************************************************************** 
** File: rtp.h
**
** Author: Mike Borella
**
** Comments: Structure of RTP packets
**
*****************************************************************************/

/*
 * Static part of RTP header
 */

typedef struct _RtpHdr
{
#if defined(WORDS_BIGENDIAN)
  u_int16_t payload_type:7,
            marker:1,
            csrc_count:4,
            extension:1,
            padding:1,
            version:2;
#else
  u_int16_t version:2,
            padding:1,
            extension:1,
            csrc_count:4,
            marker:1,
            payload_type:7;
#endif
  u_int16_t seqno;
  u_int32_t timestamp;
  u_int32_t ssrc;
  
} RtpHdr;

