/**************************************************************************** 
** File: rtp.c
**
** Author: Mike Borella
**
** Comments: Dump RTP header information. 
**
*****************************************************************************/

#include <stdio.h>
#include "config.h"
#include "rtp.h"

extern u_char *packet_end;

/*----------------------------------------------------------------------------
**
** dump_rtp()
**
** Parse RTP packet and dump fields
**
**----------------------------------------------------------------------------
*/

void dump_rtp(u_char *bp, int length)
{
  u_char *ep = bp + length;
  u_char *p;
  RtpHdr *rtp;
  int i;

  /*
   * Make sure we don't run off the end of the packet
   */

  if (ep > packet_end) 
    ep = packet_end;

  p = bp;

  printf("-----------------------------------------------------------------\n");
  printf("                        RTP Header\n");
  printf("-----------------------------------------------------------------\n");

  rtp = (RtpHdr *) p;

  printf("Version:                %d\n", (int) rtp->version);
  printf("Padding:                %d\n", (int) rtp->padding);
  printf("Extension:              %d\n", (int) rtp->extension);
  printf("CSRC count:             %d\n", (int) rtp->csrc_count);
  printf("Marker:                 %d\n", (int) rtp->marker);
  printf("Payload type:           %d\n", (int) rtp->payload_type);
  printf("Sequence number:        %d\n", (u_int16_t) rtp->seqno);
  printf("Timestamp:              %d\n", (u_int32_t) rtp->timestamp);
  printf("SSRC:                   %d\n", (u_int32_t) rtp->ssrc);
  p = p + sizeof(RtpHdr);

  /*
   * Dump contributing sources
   */

  for (i=0; i < rtp->csrc_count; i++)
    {
      printf("CSRC                    %d\n", EXTRACT_32BITS(p));
      p = p + sizeof(u_int32_t);
      if (p > ep) 
	{
	  printf("beyond end of packet\n");
	  return;
	}
    }

}
