/**************************************************************************** 
**
** File: raw.c
**
** Author: Mike Borella
**
** Comments: Dump raw data link (IP) packets
**
*****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <pcap.h>
#include "config.h"
#include "raw.h"
#include "ip.h"

u_char *packet_ptr;
u_char *packet_end;

/*----------------------------------------------------------------------------
**
** dump_raw()
**
** Process packets from the DLT_RAW interface type
**
**----------------------------------------------------------------------------
*/

void dump_raw(u_char *user, const struct pcap_pkthdr *h, u_char *p)
{
  u_int length; 
  u_int caplen;

  /*
   * Get total packet length and length of the captured section
   */

  length = h->len;
  caplen = h->caplen;

  /*
   * Some printers want to get back at the link level addresses,
   * and/or check that they're not walking off the end of the packet.
   * Rather than pass them all the way down, we set these globals.
   */
   
  packet_ptr = p;
  packet_end = p + caplen;

  /*
   * Dump raw header
   */

  printf("==========================================================\n");
  printf("                        Raw Header(%u.%06u)\n",
	 (u_int32_t) h->ts.tv_sec, (u_int32_t) h->ts.tv_usec);
  printf("----------------------------------------------------------\n");

  dump_ip(p, length);
}
