# !Nihongo,Japanese!  -*-coding: euc-jp;-*-
#
#
#
#
#   user-ja-conf
#
#   This file is a part of the Debian user-ja package.
#   Language Support File for Japanese
#
# Copyright (C) 1998-2000 Tomohiro KUBOTA
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# On Debian GNU/Linux systems, the complete text of the GNU General
# Public License can be found in `/usr/share/common-licenses/GPL'.



# This is needed to check Canna and Wnn.
use Socket;

# ---------------------------------------------------
# isNC()
# ---------------------------------------------------
sub isNC($$$)
{
	my ($KANJI, $TTY, $TERM, $DISPLAY);
	$TTY = `/usr/bin/tty`;
	$TERM = $ENV{TERM};
	$DISPLAY = $ENV{DISPLAY};
	$THIS = $_[0];
	$OPT = $_[1];
	$OPT_N = $_[2];
	
	if ($TERM eq 'kon' || $TERM eq 'kterm' || $TERM eq 'jfbterm') {
		$KANJI=1;
	} elsif ($DISPLAY ne '' && &executable("kterm") && !$OPT_N) {
		exec("kterm -km euc -e $THIS -N $OPT");
	} elsif ($DISPLAY ne '' && &executable("krxvt") && !$OPT_N) {
		exec("krxvt -km euc -e $THIS -N $OPT");
	} else {
		print STDERR &sourceset2displayset("ʸɤޤ\n");
		print STDERR "UE NO BUNSYOU (KANJI) GA YOMEMASUKA? [y/N] ";
		$a = <>;
		if ($a =~ /y|Y/) {
			$KANJI=1;
		} elsif ($TTY =~ m!/dev/tty[0-9]+! && &executable("kon") 
		  && !$OPT_N) {
			print STDERR "\"KON\" WO JIKKOU SHIMASUKA? [Y/n] ";
			$a = <>;
			exec("kon -e $THIS -N $OPT") if ($a !~ /n|N/);
			$KANJI=0;
		} else {
			$KANJI=0;
		}
	}
	$KANJI;
}

sub executable($)
{
	my($WHICH);
	$WHICH = '/usr/bin/which';
	if (system("$WHICH $_[0] >/dev/null")==0) {return 1;}
	return 0;
}


# ---------------------------------------------------
# initialize()
# ---------------------------------------------------
sub initialize()
{
	&check_im("Canna", 5680);
	&check_im("Wnn", 22273);
	&check_im("SKK", 1178);

	# ---------- select default input method ----------
	$m = 0;
	foreach $i ("Canna", "Wnn", "SKK") {
		$m += $Sub::IM_EXIST{$i};
		if ($Sub::IM_EXIST{$i}) {$def = $i;}
	}
	if ($m == 1) {
		$Sub::IM_DEFAULT = $def;
	} else {
		if ($Sub::IM_EXIST{"SKK"}) {
			$d = 3;
		} elsif ($Sub::IM_EXIST{"Wnn"}) {
			$d = 2;
		} elsif ($Sub::IM_EXIST{"Canna"}) {
			$d = 1;
		} else {
			$d = 1;
		}
		$dd = &Sub::select(
			"KANJI HENKAN NIHA DORE WO TSUKAI MASUKA ".
			"1=Canna 2=Wnn 3=SKK 4=none ",
			"ѴˤϤɤȤޤ ".
			"1=Canna 2=Wnn 3=SKK 4=ʤ ", 4, $d);
		if ($dd == 1) {$Sub::IM_DEFAULT = "Canna";}
		if ($dd == 2) {$Sub::IM_DEFAULT = "Wnn";}
		if ($dd == 3) {$Sub::IM_DEFAULT = "SKK";}
		if ($dd == 4) {$Sub::IM_DEFAULT = "";}
	}
	if ($Sub::IM_DEFAULT eq "Canna") {
		if (!$IM_EXIST{"Canna"}) {
			&Sub::addlist("canna");
		}
	} elsif ($Sub::IM_DEFAULT eq "Wnn") {
		if (!$IM_EXIST{"Wnn"}) {
			if (!&Sub::isinstalled("wnn")) {
				&Sub::addlist("freewnn-jserver");
			}
		}
	} elsif ($Sub::IM_DEFAULT eq "SKK") {
		if (!$IM_EXIST{"SKK"}) {
			if (!&Sub::isinstalled("skkserv")) {
				&Sub::addlist("dbskkd-cdb");
			}
			&Sub::addlist("skk");
		}
		system("/usr/bin/touch ~/.skk-jisyo");
	}

	# ---------- add required packages ----------
	&Sub::addlist("kon2");
	&Sub::addlist("ja-trans");
	&Sub::addlist("locale-ja");
	&Sub::addlist("locales");
	&Sub::addlist("manpages-ja");
#	&Sub::addlist("dpkg-doc-ja");
	if (&Sub::isinstalled("less")) {&Sub::addlist("jless");}
	if (&Sub::isinstalled("groff")) {&Sub::addlist("jgroff");}
	if (&Sub::isinstalled("fvwm2")) {&Sub::addlist("fvwm2-ja");}
	if (&Sub::isinstalled("fvwm95")) {&Sub::addlist("fvwm95-ja");}
#	if (&Sub::isinstalled("afterstep")) {&Sub::addlist("afterstep-i18n");}
	if (&Sub::isinstalled("tcsh")) {&Sub::addlist("tcsh-kanji");}
	if (&Sub::isinstalled("dvi2tty")) {&Sub::addlist("dvi2tty-ja");}
	if (&Sub::isinstalled("mutt")) {&Sub::addlist("mutt-ja");}
	if (&Sub::isinstalled("slrn")) {&Sub::addlist("slrn-ja");}
#	if (&Sub::isinstalled("tgif")) {&Sub::addlist("tgif-ja");}
	if (&Sub::isinstalled("xjed")) {&Sub::addlist("xjed-ja");}
	if (&Sub::isinstalled("xterm")) {&Sub::addlist("kterm");}
	if (&Sub::isinstalled("rxvt")) {&Sub::addlist("rxvt-ml");}
	if (&Sub::isinstalled("nethack")) {&Sub::addlist("jnethack");}
	if (&Sub::isinstalled("doc-debian")) {&Sub::addlist("doc-debian-ja");}
	if (&Sub::isinstalled("doc-linux")) {&Sub::addlist("doc-linux-ja");}
	if (&Sub::isinstalled("doc-debian-html")) {
		&Sub::addlist("doc-debian-html-ja");
	}

	if (&Sub::isinstalled("doc-linux-text")) {
		&Sub::addlist("doc-linux-text-ja");
	}
	if (&Sub::isinstalled("vim")) {
		&Sub::addlist("jvim-canna");
	}
	if (&Sub::isinstalled("nvi") && !&Sub::isinstalled("nvi-m17n") && 
	 !&Sub::isinstalled("nvi-m17n-canna")) {
		if ($Sub::IM_DEFAULT eq "Canna") {
			&Sub::addlist("nvi-m17n-canna");
		} else {
			&Sub::addlist("nvi-m17n");
		}
	}
	if (&Sub::isinstalled("xserver-.*")) {
		&Sub::addlist("xfonts-cjk");
		if ($Sub::IM_DEFAULT eq "SKK") {
			&Sub::addlist("skkinput");
		} elsif ($Sub::IM_DEFAULT eq "Canna") {
			if (!&Sub::isinstalled("kinput2.*canna.*")) {
				&Sub::addlist("kinput2-canna");
			}
		} elsif ($Sub::IM_DEFAULT eq "Wnn") {
			if (!&Sub::isinstalled("kinput2.*wnn.*")) {
				&Sub::addlist("kinput2-wnn");
			}
		}
	}
}

# This function is not not needed for every languages.
# only for Japanese. 
sub check_im($$)
{
	my ($im, $port, $remote);
	$im = $_[0];
	$port = $_[1];
	
	&Sub::disp("$im server GA UGOITE ", "$im Сư");
	$proto = getprotobyname("tcp");
	$in_addr = (gethostbyname("localhost"))[4];
	$addr = sockaddr_in($port, $in_addr);
	if (socket(S,AF_INET,SOCK_STREAM,$proto) && connect(S, $addr)) {
		$Sub::IM_EXIST{$im} = 1;
		$Sub::IM_HOST{$im} = "";
		close(S);
		&Sub::disp("IMASU.\n","ޤ\n");
	} else {
		$Sub::IM_EXIST{$im} = 0;
		$Sub::IM_HOST{$im} = "";
		&Sub::disp("IMASEN.\n","ޤ\n");
		$remote = &Sub::noyes(
			"network NO DOKOKA BETSUNO computer DE " . 
			"$im server GA UGOITE IMASUKA",
			"ͥåȥΤɤ̤Υԥ塼 " .
			"$im СưƤޤ");
		if ($remote) {
			$Sub::IM_HOST{$im} = &Sub::ask(
				"SONO host MEI WO NYUURYOKU SHITE KUDASAI",
				"Υۥ̾ϤƤ");
			$Sub::IM_EXIST{$im} = 1;
		}
	}
}

# ---------------------------------------------------
# sourceset2displayset()
# ---------------------------------------------------
sub sourceset2displayset ($)
{
	my ($a, $b, $r);
	$a = $_[0];
	$r = "";
	while (length($a) != 0) {
		$a =~ /^([\0-\177]*)(.*)/s;
		$b = $1; $a = $2;
		$r .= $b;

		if (length($a) != 0) {
			$a =~ /^([\200-\377]*)(.*)/s;
			$b = $1; $a = $2;
			$b =~ tr|\200-\377|\0-\177|;
			$r .= "\x1b\$B" . $b . "\x1b(B";
		}
	}
	$r;
}

# ---------------------------------------------------
# analcode()
# ---------------------------------------------------
sub analcode($)
{
	my ($c1, $c2, $string, $k);
	$string = $_[0];
	if ($string =~ /\x1b\$B/) {return 'JIS';}
	if ($string =~ /\x1b\(B/) {return 'JIS';}

	$k = 0;
	for $c (split(//,$string)) {
		$a = unpack("C", $c);
		if ($k) {
			return 'SJIS' if ($a<0xa0);
			$k = 0;
		} else {
			return 'SJIS' if ($a>0x80 && $a<0xa0);
			$k = 1 if ($a>0x80);
		}
	}
	return 'EUC';
}

# ---------------------------------------------------
# convcode()
# ---------------------------------------------------
sub convcode($$)
{
	$string = $_[0];
	$tocode = $_[1];

	# fromcode  EUC-JP ˷ޤäƤ!
	$fromcode = &analcode($string);
	if ($fromcode eq $tocode) {return $string;}
	if ($tocode eq 'JIS') {
		return sourceset2displayset($string);
	}
	if ($tocode eq 'SJIS') {
		return _euc2sjis($string);
	}
	return $string;
}

sub _euc2sjis($)
{
	my ($string);
	$string = $_[0];
	$r = "";
	$k = 0;
	for $c (split(//,$string)) {
		$a = unpack("C", $c);
		if (!$k) {
			if ($a>0x7f) {
				$c0 = $c;
				$a0 = $a;
				$k = 1;
			} else {
				$r .= $c;
			}
			next;
		}
		$a &= 0x7f;
		$a0 &= 0x7f;
		if ($a0 & 1) {
			if ($a < 0x60)   {$a += 0x1f;}
			else             {$a += 0x20;}
		} else {
					  $a += 0x7e;
		}
		if ($a0 < 0x5f) {
					  $a0 = ($a0+0xe1)>>1;
		} else {
					  $a0 = ($a0+0x161)>>1;
		}
		$r .= pack("C",$a0) . pack("C",$a);
		$k = 0;
	}
	return $r;
}

sub _sjis2euc($)
{
	my($string, $r);
	$string = $_[0];
	$r = "";
	$k = 0;
	for $c (split(//,$string)) {
		$a = unpack("C", $c);
		if (!$k) {
			if ($a>=0xa0 && $a<=0xdf) {
				$r .= pack("C", 0x8e);
			} elsif ($a >= 0x81) {
				$k = 1;
				$c0 = $c;
				$a0 = $a;
			} else {
				$r .= $c;
			}
			next;
		}
		if ($a0 <= 0x9f) {
			if ($a<0x9f) {
				$r .= pack("C", $a0*2-0xe1);
			} else {
				$r .= pack("C", $a0*2-0xe0);
			}
		} else {
			if ($a<0x9f) {
				$r .= pack("C", $a0*2-0x161);
			} else {
				$r .= pack("C", $a0*2-0x160);
			}
		}
		if ($a < 0x7f) {
			$r .= pack("C", $a-0x1f);
		} elsif ($a < 0x9f) {
			$r .= pack("C", $a-0x20);
		} else {
			$r .= pack("C", $a-0x7e);
		}
		$k = 0;
			
	}
	return $r;
}

# ---------------------------------------------------
# messages in Japanese
# ---------------------------------------------------

%messages = (

# msgid
"\nPush [Enter] key to End.\n" =>
# msgstr (in ASCII)
"\n[Enter] key WO OSUTO KONO user-ja-conf HA SYUURYOU SHIMASU.\n\000" .
# msgstr (in native character set: EUC-JP)
"\n[Enter] 򲡤Ƥλޤ\n",

# msgid
"Now obtaining package list...\n" =>
# msgstr (in ASCII)
"package ICHIRAN WO SYUTOKU SHITE IMASU...\n\000" .
# msgstr (in native character set: EUC-JP)
"ѥåƤޤ...\n" ,

# msgid
"Do setting? " =>
# msgstr (in ASCII)
"SETTEI WO OKONAI MASUKA \000" .
# msgstr (in native character set: EUC-JP)
"Ԥޤ " ,

# msgid
"Setting is not done.\n" =>
# msgstr (in ASCII)
"SETTEI SHIMASEN.\n\000" .
# msgstr (in native character set: EUC-JP)
"ꤷޤ\n" ,

# msgid
"Do setting...\n" =>
# msgstr (in ASCII)
"SETTEI SHIMASU ...\n\000" .
# msgstr (in native character set: EUC-JP)
"ꤷޤ...\n" ,

# msgid
"Cannot open \"%s\".\n" =>
# msgstr (in ASCII)
"\"%s\" WO open DEKIMASEN.\n\000" .
# msgstr (in native character set: EUC-JP)
"\"%s\" 򥪡ץǤޤ\n" ,

# msgid
"Cannot write to \"%s\".\n" =>
# msgstr (in ASCII)
"\"%s\" NI KAKIKOMI GA DEKIMASEN.\n\000" .
# msgstr (in native character set: EUC-JP)
"\"%s\" ˽񤭹ߤǤޤ\n" ,

# msgid
"Cannot lock \"%s\".\n" =>
# msgstr (in ASCII)
"\"%s\" WO lock DEKIMASEN.\n\000" .
# msgstr (in native character set: EUC-JP)
"\"%s\" åǤޤ\n" ,

# msgid
"Cannot close \"%s\".\n" =>
# msgstr (in ASCII)
"\"%s\" WO close DEKIMASEN.\n\000" .
# msgstr (in native character set: EUC-JP)
"\"%s\" 򥯥Ǥޤ\n" ,

# msgid
"Install the following packages.\n" =>
# msgstr (in ASCII)
"IKA NI SHIMESU package WO install SHITE KUDASAI.\n\000" .
# msgstr (in native character set: EUC-JP)
"ʲ˼ѥå򥤥󥹥ȡ뤷Ʋ\n" ,

# msgid
"   Setting is now done.  To activate these settings,\n".
"logout and login.\n".
"   Read each dotfile and confirm the modification.\n".
"If you don't like the setting, modify directly or\n".
"add overriding setting after 'user-ja end' line.\n".
"   Read /usr/share/doc/user-ja/README.* for detail.\n" =>
# msgstr (in ASCII)
"   SETTEI GA SYUURYOU SHIMASHIA. SETTEI WO YUUKOU NI\n" .
"SURUNIHA, ICHIDO logout SHITEKARA, FUTATABI login SHITE\n" .
"KUDASAI.\n" .
"   SOREZORE NO dotfile WO YONDE, DONOYOUNI HENKOU SARETAKA,\n" .
"KAKUNIN SHITE KUDASAI. KINI IRANAI SETTEI HA, CHOKUSETSU\n" .
"HENKOU SURUKA, 'user-ja end' IKOU NO GYOU NI SAI-SETTEI\n" .
"WO KAKI-KUWAETE KUDASAI.\n" .
"   KUWASIKUHA, /usr/share/doc/user-ja/README.eucJP WO SANSYOU\n" .
"SHITE KUDASAI.\n\000" .
# msgstr (in native character set: EUC-JP)
"  ꤬λޤͭˤˤϡ٥\n" .
"ƤƤӥ󤷤Ƥ\n" .
"  줾ΥɥåȥեɤǡɤΤ褦ѹ줿\n" .
"ǧƤʤϡľѹ뤫\n" .
"'user-ja end' ʹߤιԤ˺񤭲äƤ\n" .
"  ܤ /usr/share/doc/user-ja/README.eucJP 򻲾ȤƲ\n" ,

# msgid
"Usage: user-ja-conf [options]\n".
"  -l language : Specify language (otherwise choose from menu)\n".
"  -h          : This help message\n".
"  -v          : 'verbose mode'\n".
"  -s          : Display list of supported languages and exit\n".
"  -N          : Never fork another user-ja-conf (for internal use)\n" =>
# msgstr (in ASCII)
"Tsukaikata: user-ja-conf [options]\n" .
"  -l GENGO    : GENGO WO SHITEI SURU (NAKEREBA menu KARA ERABU)\n" .
"  -h          : KONO help message\n" .
"  -v          : 'verbose mode'\n" .
"  -s          : support SARETE IRU GENGO NO ICHIRAN WO HYOUJI SHITE\n" .
"                SYUURYOU SURU\n" .
"  -N          : BETSU NO user-ja-conf WO fork SHINAI (NAIBU DE SHIYOU SURU)\n\000" .
# msgstr (in native character set: EUC-JP)
"Ȥ: user-ja-conf [ץ]\n" .
"  -l      : ꤹ (ʤХ˥塼)\n" .
"  -h          : Υإץå\n" .
"  -v          : ¹Իξܤɽ\n" .
"  -s          : ݡȤƤΰɽƽλ\n" .
"  -N          : ̤ user-ja-conf  fork ʤ (ǻѤ)\n"

);

$yes_upper = "Y";
$yes_lower = "y";
$no_upper = "N";
$no_lower = "n";
