user-ja is a package to construct Japanese environment easily.
This environment construction is done by making or modifying
dot-files.  So each user has to construct his/her environment
by invoking user-ja-conf.

Dot-files means files in users' home directories whose names begin 
with dot (or period).

Invoking user-ja-conf inserts various settings for Japanese
language enabling surrounded by "---- user-ja" comments into
your dot files.  These settings are added at the last of your
existing dot files at the first time you invoke user-ja-conf.
You can add settings before or after the added region and
you can modify the added settings.  When you again invoke 
user-ja-conf (for example when user-ja is updated), the old 
settings surrounded by "---- user-ja" are replaced by the new 
settings.  Thus if you have modified the added settings, this
modification is lost.  Settings outside the surrounded region 
are not affected.  Don't modify the "---- user-ja" lines.


See README.eucJP for further information for Japanese users.

See README.i18n for further information on adding a new language
support.


About Codeset
=============

The following codesets can express Japanese:
 * ISO-2022-JP (aka JIS)
 * EUC-JP (Japanese EUC)
 * SHIFT-JIS (aka MS Kanji Code)
 * Unicode (UTF-8 is the most popular)
This package adopts EUC-JP, according to "Policy on Japanese
Locale on Linux" Version 1.03, 
http://www.linux.or.jp/JF/JFdocs/Japanese-Locale-Policy.txt.
However, the value for LANG variable is 'ja_JP.ujis', not
'ja_JP.eucJP' in this version of user-ja.


Packages Needed for Japanese Environment
========================================

Though user-ja establishes Japanese environment with modifying personal
dot-files, it does not install additional packages needed for Japanese
environment.  Now these needed packages are explained.


Display
-------

At first, an environment has to be prepared where Japanese character 
or Kanji can be displayed. Install the following package:
 * 'kon2' for ordinal console
 * 'jfbterm' for frame buffer console
 * 'kterm' or 'rxvt-ml' for X Window System
Then invoke
 * 'kon' in ordinal console
 * 'jfbterm' in frame buffer console
 * 'kterm' or 'krxvt' in X Window System
You also need 'xfonts-cjk' package for X.

Next, install Japanese-capable pager package 'lv' or 'jless'.
They can automatically distinguish codesets and properly display
Japanese text file written in various codesets.

Some window manager can display Japanese at window title and
others cannot.  'asclassic', 'qvwm', 'icewm', 'blackbox', and so on 
can without any additional settings.  'wmaker' and so on can
with additional settings.  However, this version of user-ja
does not set anything on window managers.

# Of course environmental variable 'LANG' has to be set properly
# for all window managers.  This is well managed by user-ja and
# you don't need to think about it.

If you use wmaker, invoke 'wsetfont japanese'.


Input
-----

You need a Kana-Kanji conversion software to input Japanes.
You can choose one of the following softwares:
 * Canna : install 'canna'
 * Wnn : install 'freewnn-jserver'
 * SKK : install 'skk' and 'dbskkd-cdb'
Then you have to prepare connection between these conversion softwares
and each software you use.

You need 'yc-el' package when you use Canna in GNU Emacs.

Many softwares on X Window System use Kinput2 or XIM protocol.
You need
 * 'kinput2-canna' for Canna
 * 'kinput2-wnn' for Wnn
 * 'skkinput' for SKK
which connect between these conversion software and XIM protocol.


Text Processing
---------------

You can use
 * grep-ja
 * sed-ja
 * gawk-ja
for text processing.  Debian package for Japanese version of perl
is not available.


Others
------

All of you will need
 * locale-ja
 * locales

The following are mail readers which can handle Japanese
 * mew
 * mutt-ja
 * wl
 * mh
 * im

The following are web browsers which can display Japanese
 * netscape
 * mozilla
 * lynx
 * w3m
 * w3 on emacs
You cannot input Japanese on netscape.

The following are editors which can handle Japanese
 * emacs20
 * emacs20-dl
 * xemacs20-mule
 * xemacs20-mule-canna-wnn
 * xemacs21-mule
 * xemacs21-mule-canna-wnn
 * mule2
 * nvi-m17n and nvi-m17n-canna
 * jed-ja and jed-canna
 * jvim-canna
 * yudit
 * gedit
 * dedit

You can install many Japanese-related package using
 * task-japanese


Copyright
=========

See /usr/share/doc/user-ja/copyright.

---
Tomohiro KUBOTA <kubota@debian.or.jp>  Mon, 18 Oct 1999
