
/*********************************************************************
 *                
 * Filename:      thinkpad_mod_defines.h
 * Description:   header that sets up #defines for the thinkpad module
 * Status:        beta
 * Author:        Thomas Hood <jdthood@mail.com>
 * Created:       28 July 1999 
 *
 * Please report bugs to the author ASAP.
 * 
 *     Copyright (c) 1999 J.D. Thomas Hood, All rights reserved
 *     
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *     GNU General Public License for more details.
 * 
 *     To receive a copy of the GNU General Public License, please write
 *     to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 *     Boston, MA 02111-1307 USA
 *     
 ********************************************************************/

#ifndef __THINKPAD_MOD_DEFINES_H__
#define __THINKPAD_MOD_DEFINES_H__

#include <linux/config.h>

#if CONFIG_MODVERSIONS==1
#	ifndef MODVERSIONS
#		define MODVERSIONS
#	endif
#endif

#if (defined(FORCE_MODVERSIONS) && FORCE_MODVERSIONS==1)
#	ifndef MODVERSIONS
#		warning Forcing compilation with MODVERSIONS
#		define MODVERSIONS
#	endif
#endif

#if (defined(FORCE_MODVERSIONS) && FORCE_MODVERSIONS==0)
#	ifdef MODVERSIONS
#		warning Forcing compilation without MODVERSIONS
#		undef MODVERSIONS
#	endif
#endif

#ifdef MODVERSIONS
	/* This has to follow something that includes config.h and precede
	 * headers that declare kernel functions that we use */
#	include <linux/modversions.h>
#endif

#ifdef CONFIG_PROC_FS
#	ifndef USE_PROC_FS
#		define USE_PROC_FS
#	endif
#       include <linux/version.h>
#       if LINUX_VERSION_CODE >= KERNEL_VERSION(2,3,0)
#	       define NEW_PROC
#       endif
#endif

#endif
