/* This file is part of Malaga, a system for Natural Language Analysis.
 * Copyright (C) 1995-1999 Bjoern Beutel
 *
 * Bjoern Beutel
 * Universitaet Erlangen-Nuernberg
 * Abteilung fuer Computerlinguistik
 * Bismarckstrasse 12
 * D-91054 Erlangen
 * e-mail: malaga@linguistik.uni-erlangen.de 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* description ==============================================================*/

/* This module contains options that can be set by both malaga and mallex. */

/* variables ================================================================*/

GLOBAL bool_t show_variables; /* show variables in debug mode? */
GLOBAL bool_t show_result; /* show result graphically? */
GLOBAL bool_t show_output; /* show output after analysis? */

/* commands =================================================================*/

extern command_t sort_records_option;
/* Select the order in which attributes in a record are printed. */

extern command_t hidden_option;
/* Select which attributes to hide when printing values. */

extern command_t result_option; 
/* Determine if result is shown after analysis. */

extern command_t output_option;
/* Determine if output is printed after analysis. */

extern command_t variables_option; 
/* Determine if variables are displayed in debug mode. */

extern command_t switch_option;
/* Set switches that can be read from Malaga rules. */

#ifdef HANGUL
extern command_t hangul_option; /* Select KSC5601 or Roman output. */
#endif

/* end of file ==============================================================*/
