/* This file is part of Malaga, a system for Natural Language Analysis.
 * Copyright (C) 1995-1999 Bjoern Beutel
 *
 * Bjoern Beutel
 * Universitaet Erlangen-Nuernberg
 * Abteilung fuer Computerlinguistik
 * Bismarckstrasse 12
 * D-91054 Erlangen
 * e-mail: malaga@linguistik.uni-erlangen.de 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* description ==============================================================*/

/* This module handles the conversion of KSC5601 hangul characters and 
 * romanised Hangul to internal format (and back). */

/* variables ================================================================*/

GLOBAL bool_t convert_to_ksc; 
/* Indicates whether Hangul output is converted to KSC5601
 * (else output is converted to romanised Hangul). */

/* functions ================================================================*/

extern void init_hangul (void);
/* Initialise hangul conversions. */

extern void terminate_hangul (void);
/* Free memory used by hangul conversions. */

extern void decode_hangul (string_t *string_ptr);
/* Decode <*string_ptr> to external format.
 * <*string_ptr> must be a string on the heap; 
 * it will be replaced by the new string which is also on the heap. */

extern void encode_hangul (string_t *string_ptr);
/* Encode <*string_ptr> to internal format.
 * <*string_ptr> must be a string on the heap; 
 * it will be replaced by the new string which is also on the heap. */

/* end of file ==============================================================*/
