-- foreign key check functions
-- Requires: postgresql-test
-- the functions have local names because referencial integrity isn't
-- provided on system tables....

-- **** GLOBAL FUNCTIONS **** --
CREATE FUNCTION check_primary_key ()
	RETURNS opaque
	AS '/usr/lib/postgresql/test/contrib/spi/refint.so'
	LANGUAGE 'c'
;

CREATE FUNCTION check_foreign_key ()
	RETURNS opaque
	AS '/usr/lib/postgresql/test/contrib/spi/refint.so'
	LANGUAGE 'c'
;


-- **** TABLES **** --

CREATE SEQUENCE objid_seq;

GRANT SELECT ON objid_seq TO GROUP barracuda_read;
-- GRANT UPDATE ON objid_seq TO GROUP barracuda_write;
-- GRANT ALL ON objid_seq TO GROUP barracuda_admin;

-- ** PERSON ** --
CREATE TABLE person (
	name		varchar(16) primary key,
	created 	datetime,
	fullname	varchar(40),
	telno		varchar(30),
	email		text,
	post		text,
	refid		varchar(20),
	comment		text
);
GRANT SELECT ON person TO GROUP barracuda_read;
GRANT SELECT ON person TO GROUP barracuda_write;
GRANT ALL ON person TO GROUP barracuda_admin;
-- ** GRP ** --
CREATE TABLE grp (
	name		varchar(16) primary key,
	systemgrp	bool
);
GRANT SELECT ON grp TO GROUP barracuda_read;
GRANT ALL ON grp TO GROUP barracuda_write;
GRANT ALL ON grp TO GROUP barracuda_admin;

-- ** USR2GRP ** --
CREATE TABLE usr2grp (
	usr	varchar(16) references person(name),
	grp	varchar(16) references grp(name),
	manager	bool,
	reader	bool,
	writer	bool
);
GRANT SELECT ON usr2grp TO GROUP barracuda_read;
GRANT ALL ON usr2grp TO GROUP barracuda_write;
GRANT ALL ON usr2grp TO GROUP barracuda_admin;

-- ** OBJTYPE ** --
CREATE TABLE objtype (
	name		varchar(16) primary key
);
GRANT SELECT ON objtype TO GROUP barracuda_read;
GRANT SELECT ON objtype TO GROUP barracuda_write;
GRANT ALL ON objtype TO GROUP barracuda_admin;
INSERT INTO objtype VALUES ('Class');
INSERT INTO objtype VALUES ('Task');
INSERT INTO objtype VALUES ('Document');

-- ** OBJSTATE ** --
CREATE TABLE objstate (
	rank		int2,
	name		varchar(16) primary key
);
GRANT SELECT ON objstate TO GROUP barracuda_read;
GRANT SELECT ON objstate TO GROUP barracuda_write;
GRANT ALL ON objstate TO GROUP barracuda_admin;
INSERT INTO objstate VALUES (10, 'Open');
INSERT INTO objstate VALUES (20, 'Feedback');
INSERT INTO objstate VALUES (30, 'Suspended');
INSERT INTO objstate VALUES (40, 'Closed');
INSERT INTO objstate VALUES (100, 'Unknown');
INSERT INTO objstate VALUES (999, 'Nothing');

-- ** OBJPRIORITY ** --
CREATE TABLE objpriority (
	rank		int2,
	name		varchar(16) primary key
);
GRANT SELECT ON objpriority TO GROUP barracuda_read;
GRANT SELECT ON objpriority TO GROUP barracuda_write;
GRANT ALL ON objpriority TO GROUP barracuda_admin;
INSERT INTO objpriority VALUES (10, 'URGENT');
INSERT INTO objpriority VALUES (20, 'High');
INSERT INTO objpriority VALUES (30, 'Normal');
INSERT INTO objpriority VALUES (40, 'Low');
INSERT INTO objpriority VALUES (50, 'Bulk');

-- ** OBJECT ** --
CREATE TABLE object (
	id		int4 primary key DEFAULT nextval('objid_seq'),
	name		varchar(80),
	type		varchar(16) references objtype(name),
	parent		int4 references object(id),
	acl		varchar(16) references grp(name),
	lockby		varchar(16) references person(name) DEFAULT NULL,
	created		datetime,
	modified	datetime,
	accessed	datetime,
	creator		varchar(16) references person(name)
);
GRANT SELECT ON object TO GROUP barracuda_read;
GRANT ALL ON object TO GROUP barracuda_write;
GRANT ALL ON object TO GROUP barracuda_admin;
CREATE INDEX idx_object_parent ON object(parent);

-- ** TASK_LIST ** --
CREATE VIEW task_list AS SELECT id FROM object WHERE type='Task';
GRANT SELECT ON task_list TO GROUP barracuda_read;
GRANT SELECT ON task_list TO GROUP barracuda_write;
GRANT SELECT ON task_list TO GROUP barracuda_admin;

-- ** TASK_OBJECT ** --
CREATE TABLE task_object (
	id	 	int4 references object(id),
	priority	varchar(16) references objpriority(name),
	state		varchar(16) references objstate(name),
	minbegin	datetime,
	maxend		datetime,
	duration	interval,
	taskbegin	datetime,
	taskend		datetime
);

GRANT SELECT ON task_object TO GROUP barracuda_read;
GRANT INSERT,UPDATE,DELETE ON task_object TO GROUP barracuda_write;
GRANT ALL ON task_object TO GROUP barracuda_admin;

-- ** DOC_LIST ** --
CREATE VIEW doc_list AS SELECT id FROM object WHERE type='Document';
GRANT SELECT ON doc_list TO GROUP barracuda_read;
GRANT SELECT ON doc_list TO GROUP barracuda_write;
GRANT SELECT ON doc_list TO GROUP barracuda_admin;

-- ** DOC_OBJECT ** --
CREATE TABLE doc_object (
	id		int4 references object(id),
	refno		varchar(24) unique,
	keywords	text,
	mimetype	varchar(30) references mimetype(name),
	attachment	text
);

GRANT SELECT ON doc_object TO GROUP barracuda_read;
GRANT SELECT,INSERT,UPDATE ON doc_object TO GROUP barracuda_write;
GRANT ALL ON doc_object TO GROUP barracuda_admin;

-- ** MIMETYPE ** --
CREATE TABLE mimetype (
	name            varchar(30) primary key,
	description     varchar(40)
);
GRANT SELECT ON mimetype TO GROUP barracuda_read;

-- ** DEFAULT FILLUPS ** --

DELETE FROM person;
DELETE FROM grp;
DELETE FROM usr2grp;

INSERT INTO person (created, name, fullname, telno, email, post, comment) values ('now','admin','Barracuda Administrator','','','','');
INSERT INTO grp (name,systemgrp) VALUES ('admin','t');
INSERT INTO grp (name,systemgrp) VALUES ('write','t');
INSERT INTO grp (name,systemgrp) VALUES ('read','t');
INSERT INTO grp (name,systemgrp) VALUES ('public','f');
INSERT INTO usr2grp (usr,grp,reader,writer,manager) VALUES ('admin', 'admin', 't', 't', 't');
INSERT INTO usr2grp (usr,grp,reader,writer,manager) VALUES ('admin', 'public', 't', 't', 't');
INSERT INTO object (id, parent, created, modified, acl, creator, name, type) VALUES (0, 0, 'now', '-infinity', 'admin', 'admin', '-Root-', 'Class');

CREATE TABLE barracuda_version (version int, minor int);
INSERT INTO barracuda_version (version, minor) VALUES (0, 8);
GRANT ALL ON barracuda_version TO GROUP barracuda_admin;
