/*
 *  Appindex browser
 *  Copyright (C) 1999 Martin Hinner <mhi@penguin.cz>
 *  $Id: browser.c,v 0.5 1999/08/16 23:42:44 mhi Exp root $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "config.h"
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "appindex.h"

void
run_man ()
{
  int rc;

  rc = system ("man 1 appindex");
  if (rc == -1 || rc == 127)
    error ("Cannot run man!");
}

void
run_browser (char *url)
{
  int rc;
  char cmdline[0x100];
  char buf[256] = "";
  char *var;

  var = "URL=";

  strcat (buf, var);
  strcat (buf, url);

  putenv (buf);

  if (!strstr (browser, "$URL"))
    snprintf (cmdline, 0x100, "%s%s", browser, url);
  else
    snprintf (cmdline, 0x100, "%s", browser);
  rc = system (cmdline);
  if (rc == -1 || rc == 127)
    error ("Error launching browser!");
}
