// $Header: /home/abyss/prj/include/RCS/utils.hh,v 1.4 1996/10/07 12:35:32 aml Exp $
/**************************************************************

Program: SMOG - Selection of Minimal Ordered Graphs

Author: Arlindo Oliveira (aml@ic.eecs.berkeley.edu)

Copyright 1994 University of California Berkeley / CAD Group

This software may not be distributed without 
permission of the copyright holder.


****************************************************************/

#ifndef _UTILS_DOT_HH_
#define _UTILS_DOT_HH_



#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include <ctype.h>
#include <math.h>
#include <time.h>

#define internal_error() {cerr << "Internal error in file " << __FILE__ << \
                          " at line " << __LINE__ << "\n"; exit(-1); }


#define TRUE 1
#define FALSE 0

#include "utils.h"

#ifndef ABS
#define ABS(a)			((a) < 0 ? -(a) : (a))
#endif
#ifndef MAX
#define MAX(a,b)		((a) > (b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b)		((a) < (b) ? (a) : (b))
#endif

#define panic(msg) err_print(msg)

void err_print(char *message);
void err_print(char *message,int n);
void err_print(char *message,char *st);
void err_print(char *message,char c);
char *strsave(char *st);
char *strnsave(char *st, int n);

float ran();
int iran(int limit);
void sran(int seed);
float ran3(int &idum);


#endif // _UTILS_DOT_HH_

// $Log: utils.hh,v $
// Revision 1.4  1996/10/07 12:35:32  aml
// First cut at error handling.
// Date formats are in.
// Fixed problem with blank cell drawing.
//
//Revision 1.3  1996/02/16  18:04:06  aml
//Fixed a memory bug in formula copy with purify.
//Fixed a few minor bugs. Functional, stable version.
//
// Revision 1.2  1996/02/13 21:55:22  aml
// Fixed problems with change to elf.
// RangeCopy created. Works !
// Pressed mouse leaving canvas will cause scroll. Works, but needs to
// keep moving.
//
// Revision 1.1  1995/12/30 14:53:45  aml
// Initial revision
//
//Revision 1.2  1994/09/10  16:04:22  aml
//Made changes to compile on hp.
//
//Revision 1.1  94/09/08  00:01:27  00:01:27  aml
//Initial revision
//
