# $Id: print.tcl,v 1.6 1998/09/04 02:28:01 cthulhu Exp $

proc printSetup {} {
    source "[xxl_library]/globalvars.tcl"

    getPrintParamsFromSheet

    computePrintParams

    toplevel .printsetup
    frame .printsetup.topf
    frame .printsetup.botf
    frame .printsetup.topf.lf
    frame .printsetup.topf.lf.f1 -relief ridge -borderw 2

    frame .printsetup.topf.lf.f3 -relief ridge -borderw 2
    radiobutton .printsetup.topf.lf.f3.color1 -variable colorMode \
            -value "mono" -text "Black and white" \
            -command {computePrintParams}
   radiobutton .printsetup.topf.lf.f3.color2 -variable colorMode \
            -value "gray" -text "Gray scale" \
            -command {computePrintParams}
    radiobutton .printsetup.topf.lf.f3.color3 -variable colorMode \
            -value "color" -text "Full color" \
            -command {computePrintParams}
    pack .printsetup.topf.lf.f3 -anchor w -fill x -expand true
    pack .printsetup.topf.lf.f3.color1 -anchor w
    pack .printsetup.topf.lf.f3.color2 -anchor w
    pack .printsetup.topf.lf.f3.color3 -anchor w

    
    
    entry .printsetup.topf.lf.f1.scale -textvariable scale
    bind .printsetup.topf.lf.f1.scale <Return> {computePrintParams}
    bind .printsetup.topf.lf.f1.scale <Leave> {computePrintParams}
    label .printsetup.topf.lf.f1.scale_name -text Scale
    pack .printsetup.topf.lf.f1.scale_name -side left -fill x -expand yes
    pack .printsetup.topf.lf.f1.scale -side right -fill x -expand yes
    pack .printsetup.topf.lf.f1 -fill x -expand yes

    frame .printsetup.topf.lf.f4 -relief ridge -borderw 2
    checkbutton .printsetup.topf.lf.f4.borders -variable showCellBorders \
            -text "Show cell borders" \
	-command {ToggleDisplayBorders $activeSheet ;\
            toggleCellBordersDisplay } 
    pack .printsetup.topf.lf.f4.borders -anchor w

    checkbutton .printsetup.topf.lf.f4.pages -variable showPageBorders \
            -text "Show page borders" \
            -command { TogglePageBorders $activeSheet ;\
            togglePageBordersDisplay }
    pack .printsetup.topf.lf.f4.pages -anchor w


    pack .printsetup.topf.lf.f4 -fill x -expand true


    frame .printsetup.topf.lf.f5 
    radiobutton .printsetup.topf.lf.f5.range -text "Range to print" \
            -variable printRangeSpec -value 2 -command { \
            set s [split $printRangeName :]; \
            set s [ParseRange [lindex $s 0] [lindex $s 1]] ; \
            SetPrintRange $activeSheet 2 [lindex $s 0] [lindex $s 1] \
                                         [lindex $s 2] [lindex $s 3] ;\
            computePrintParams
    }
    
    entry .printsetup.topf.lf.f5.entry -textvariable printRangeName 
    frame .printsetup.topf.lf.f8 
    radiobutton .printsetup.topf.lf.f8.range -text "Whole sheet" -variable printRangeSpec -value 1 -command {SetPrintRange $activeSheet 1 0 0 0 0 ; computePrintParams}
    label .printsetup.topf.lf.f8.entry -textvariable wholeRangeName

    pack .printsetup.topf.lf.f5.range -side left -anchor w
    pack .printsetup.topf.lf.f5.entry -side right -anchor e
    pack .printsetup.topf.lf.f8.range -side left -anchor w
    pack .printsetup.topf.lf.f8.entry 
    pack .printsetup.topf.lf.f5 .printsetup.topf.lf.f8 -fill x -expand true
            


    frame .printsetup.topf.rf     -relief ridge -borderw 2



    frame .printsetup.topf.rf.f1
    frame .printsetup.topf.rf.f2
    frame .printsetup.topf.rf.f3
    frame .printsetup.topf.rf.f4
    label .printsetup.topf.rf.f1.marginlab1 -text "Left margin"
    label .printsetup.topf.rf.f2.marginlab2 -text "Right margin"
    label .printsetup.topf.rf.f3.marginlab3 -text "Top margin"
    label .printsetup.topf.rf.f4.marginlab4 -text "Bottom margin"
    entry .printsetup.topf.rf.f1.margin1 -textvariable leftMargin
    entry .printsetup.topf.rf.f2.margin2 -textvariable rightMargin
    entry .printsetup.topf.rf.f3.margin3 -textvariable topMargin
    entry .printsetup.topf.rf.f4.margin4 -textvariable bottomMargin

    pack .printsetup.topf.rf.f1.marginlab1 -side left \
            -anchor w
    pack .printsetup.topf.rf.f2.marginlab2  -side left \
            -anchor w
    pack .printsetup.topf.rf.f3.marginlab3  -side left \
            -anchor w
    pack .printsetup.topf.rf.f4.marginlab4  -side left \
            -anchor w
    pack .printsetup.topf.rf.f1.margin1 -side right \
            -anchor e
    pack .printsetup.topf.rf.f2.margin2 -side right \
            -anchor e
    pack .printsetup.topf.rf.f3.margin3 -side right \
            -anchor e
    pack .printsetup.topf.rf.f4.margin4 -side right \
            -anchor e
    pack .printsetup.topf.rf.f1 .printsetup.topf.rf.f2 .printsetup.topf.rf.f3 \
            .printsetup.topf.rf.f4 -fill x -expand yes
    pack .printsetup.topf.rf

    frame .printsetup.topf.rf.f5     -relief ridge -borderw 2

    frame .printsetup.topf.rf.f7 -relief ridge -borderw 2
    radiobutton .printsetup.topf.rf.f7.portrait -variable typeView -text "Portrait" \
            -value 0 -command {computePrintParams}
    radiobutton .printsetup.topf.rf.f7.landscape -variable typeView -text "Landscape" \
            -value 1 -command {computePrintParams}
    pack .printsetup.topf.rf.f7.portrait .printsetup.topf.rf.f7.landscape -anchor w
    pack .printsetup.topf.rf.f7 -fill x



    radiobutton .printsetup.topf.rf.f5.a4 -text "A4" -variable pageType \
            -value A4 -command {computePrintParams}

    radiobutton .printsetup.topf.rf.f5.letter -text "US Letter" \
            -variable pageType -value USLetter -command {computePrintParams}

    pack .printsetup.topf.rf.f5.a4 .printsetup.topf.rf.f5.letter \
            -anchor w
    pack .printsetup.topf.rf.f5 -fill x -expand yes
    pack .printsetup.topf.lf .printsetup.topf.rf -side left -fill both  -expand yes

    button .printsetup.botf.ok -text Ok -command {computePrintParams; destroy .printsetup}
    button .printsetup.botf.abort -text Abort -command {destroy .printsetup}
    pack .printsetup.botf.abort .printsetup.botf.ok -fill x -expand yes -side bottom 
    pack .printsetup.topf .printsetup.botf -fill both -expand yes

    tkwait window .printsetup
    

    
}

proc getPrintParamsFromSheet {} {
    source "[xxl_library]/globalvars.tcl"

    set pp [GetPrintParams $activeSheet]

    if {[llength $pp] != 0} {

        set leftMargin [lindex $pp 0] 
        set rightMargin [lindex $pp 1]
        set topMargin [lindex $pp 2]
        set bottomMargin [lindex $pp 3]
        set scale [lindex $pp 4]
        set colorMode [lindex $pp 5]
        set typeView [lindex $pp 6]
        set fromPage [lindex $pp 7]
        set toPage [lindex $pp 8]
        if {$toPage == 0} {
            set toPage ""
        }
        
        set pageType [lindex $pp 9]
    }

    set pp [GetPrintRange $activeSheet]
    set printRangeSpec [lindex $pp 0]
    set sel $printRangeSpec

    if {$sel == 1} {
        set activePrintRange "[lindex $pp 1] [lindex $pp 2] [lindex $pp 3] \
        [lindex $pp 4]"
    } else {
        set activePrintRange "[lindex $pp 5] [lindex $pp 6] [lindex $pp 7] \
                [lindex $pp 8]"

    }
    set wholeRange "[lindex $pp 1] [lindex $pp 2] [lindex $pp 3] \
            [lindex $pp 4] "
    set wholeRangeName [rangeName $wholeRange]
    set printRange "[lindex $pp 5] [lindex $pp 6] [lindex $pp 7] \
            [lindex $pp 8]" 
    set printRangeName [rangeName $printRange]


    
}

proc computePrintParams {} {
    source "[xxl_library]/globalvars.tcl"

    set paperWidth [expr $paperWidthTable($pageType)-$leftMargin-$rightMargin]
    set paperHeight [expr $paperHeightTable($pageType)-$topMargin-$bottomMargin]



    if {$showPageBorders} {
        [canvasFromSheet $activeSheet] delete pageLimits
        doViewPages 
    }

    SetPrintParams $activeSheet $leftMargin $rightMargin $topMargin $bottomMargin \
            $scale $colorMode $typeView $fromPage $toPage $pageType

}


# $Log: print.tcl,v $
# Revision 1.6  1998/09/04 02:28:01  cthulhu
# ToggleDisplayBorders was being called with 2 args instead of 1
#
# Revision 1.5  1998/09/04 00:32:21  cthulhu
# Removed tons of error messages.
#
# Revision 1.4  1997/03/27 10:00:38  aml
# Started implementing graphs.
# Fixed bug in tkCanvasPs.c
# Created bindings for composite characters in Portuguese.
#
# Revision 1.3  1997/02/10  15:10:06  aml
# Print settings now are saved to file.
# Fixed buggy error message when loading sheets.
#
# Revision 1.2  1997/01/10 17:56:42  aml
# None
#

