/* $Id: xxl_incs.h,v 1.2 1998/09/30 00:50:44 cthulhu Exp $ */

typedef struct RectOvalItem  {
    Tk_Item header;		/* Generic stuff that's the same for all
				 * types.  MUST BE FIRST IN STRUCTURE. */
    double bbox[4];		/* Coordinates of bounding box for rectangle
				 * or oval (x1, y1, x2, y2).  Item includes
				 * x1 and x2 but not y1 and y2. */
    int width;			/* Width of outline. */
    XColor *outlineColor;	/* Color for outline. */
    XColor *fillColor;		/* Color for filling rectangle/oval. */
    Pixmap fillStipple;		/* Stipple bitmap for filling item. */
    GC outlineGC;		/* Graphics context for outline. */
    GC fillGC;			/* Graphics context for filling item. */
    short col1, col2;
    short row1, row2;
} RectOvalItem;

typedef struct TextLine {
    char *firstChar;		/* Pointer to the first character in this
				 * line (in the "text" field of enclosing
				 * text item). */
    int numChars;		/* Number of characters displayed in this
				 * line. */
    int totalChars;		/* Total number of characters included as
				 * part of this line (may include an extra
				 * space character at the end that isn't
				 * displayed). */
    int x, y;			/* Origin at which to draw line on screen
				 * (in integer pixel units, but in canvas
				 * coordinates, not screen coordinates). */
    int x1, y1;			/* Upper-left pixel that is part of text
				 * line on screen (again, in integer canvas
				 * pixel units). */
    int x2, y2;			/* Lower-left pixel that is part of text
				 * line on screen (again, in integer canvas
				 * pixel units). */
} TextLine;

typedef struct TextItem  {
    Tk_Item header;		/* Generic stuff that's the same for all
				 * types.  MUST BE FIRST IN STRUCTURE. */
    Tk_CanvasTextInfo *textInfoPtr;
				/* Pointer to a structure containing
				 * information about the selection and
				 * insertion cursor.  The structure is owned
				 * by (and shared with) the generic canvas
				 * code. */
    /*
     * Fields that are set by widget commands other than "configure".
     */
     
    double x, y;		/* Positioning point for text. */
    int insertPos;		/* Insertion cursor is displayed just to left
				 * of character with this index. */

    /*
     * Configuration settings that are updated by Tk_ConfigureWidget.
     */

    Tk_Anchor anchor;		/* Where to anchor text relative to (x,y). */
    XColor *color;		/* Color for text. */
    Tk_Font tkfont;		/* Font for drawing text. */
    Tk_Justify justify;		/* Justification mode for text. */
    Pixmap stipple;		/* Stipple bitmap for text, or None. */
    char *text;			/* Text for item (malloc-ed). */
    int width;			/* Width of lines for word-wrap, pixels.
				 * Zero means no word-wrap. */

    /*
     * Fields whose values are derived from the current values of the
     * configuration settings above.
     */

    int numChars;		/* Number of non-NULL characters in text. */
    Tk_TextLayout textLayout;	/* Cached text layout information. */
    int leftEdge;		/* Pixel location of the left edge of the
				 * text item; where the left border of the
				 * text layout is drawn. */
    int rightEdge;		/* Pixel just to right of right edge of
				 * area of text item.  Used for selecting up
				 * to end of line. */
    GC gc;			/* Graphics context for drawing text. */
    GC selTextGC;		/* Graphics context for selected text. */
    GC cursorOffGC;		/* If not None, this gives a graphics context
				 * to use to draw the insertion cursor when
				 * it's off.  Used if the selection and
				 * insertion cursor colors are the same.  */
  short col;
  short row;
} TextItem;

typedef struct LineItem  {
    Tk_Item header;		/* Generic stuff that's the same for all
				 * types.  MUST BE FIRST IN STRUCTURE. */
    Tk_Canvas canvas;		/* Canvas containing item.  Needed for
				 * parsing arrow shapes. */
    int numPoints;		/* Number of points in line (always >= 2). */
    double *coordPtr;		/* Pointer to malloc-ed array containing
				 * x- and y-coords of all points in line.
				 * X-coords are even-valued indices, y-coords
				 * are corresponding odd-valued indices. If
				 * the line has arrowheads then the first
				 * and last points have been adjusted to refer
				 * to the necks of the arrowheads rather than
				 * their tips.  The actual endpoints are
				 * stored in the *firstArrowPtr and
				 * *lastArrowPtr, if they exist. */
    int width;			/* Width of line. */
    XColor *fg;			/* Foreground color for line. */
    Pixmap fillStipple;		/* Stipple bitmap for filling line. */
    int capStyle;		/* Cap style for line. */
    int joinStyle;		/* Join style for line. */
    GC gc;			/* Graphics context for filling line. */
    GC arrowGC;			/* Graphics context for drawing arrowheads. */
    Tk_Uid arrow;		/* Indicates whether or not to draw arrowheads:
				 * "none", "first", "last", or "both". */
    float arrowShapeA;		/* Distance from tip of arrowhead to center. */
    float arrowShapeB;		/* Distance from tip of arrowhead to trailing
				 * point, measured along shaft. */
    float arrowShapeC;		/* Distance of trailing points from outside
				 * edge of shaft. */
    double *firstArrowPtr;	/* Points to array of PTS_IN_ARROW points
				 * describing polygon for arrowhead at first
				 * point in line.  First point of arrowhead
				 * is tip.  Malloc'ed.  NULL means no arrowhead
				 * at first point. */
    double *lastArrowPtr;	/* Points to polygon for arrowhead at last
				 * point in line (PTS_IN_ARROW points, first
				 * of which is tip).  Malloc'ed.  NULL means
				 * no arrowhead at last point. */
    int smooth;			/* Non-zero means draw line smoothed (i.e.
				 * with Bezier splines). */
    int splineSteps;		/* Number of steps in each spline segment. */
    short col1, col2;
    short row1, row2;
} LineItem;

typedef struct ArcItem  {
    Tk_Item header;             /* Generic stuff that's the same for all
                                 * types.  MUST BE FIRST IN STRUCTURE. */
    double bbox[4];             /* Coordinates (x1, y1, x2, y2) of bounding
                                 * box for oval of which arc is a piece. */
    double start;               /* Angle at which arc begins, in degrees
                                 * between 0 and 360. */
    double extent;              /* Extent of arc (angular distance from
                                 * start to end of arc) in degrees between
                                 * -360 and 360. */
    double *outlinePtr;         /* Points to (x,y) coordinates for points
                                 * that define one or two closed polygons
                                 * representing the portion of the outline
                                 * that isn't part of the arc (the V-shape
                                 * for a pie slice or a line-like segment
                                 * for a chord).  Malloc'ed. */
    int numOutlinePoints;       /* Number of points at outlinePtr.  Zero
                                 * means no space allocated. */
    int width;                  /* Width of outline (in pixels). */
    XColor *outlineColor;       /* Color for outline.  NULL means don't
                                 * draw outline. */
    XColor *fillColor;          /* Color for filling arc (used for drawing
                                 * outline too when style is "arc").  NULL
                                 * means don't fill arc. */
    Pixmap fillStipple;         /* Stipple bitmap for filling item. */
    Pixmap outlineStipple;      /* Stipple bitmap for outline. */
    Tk_Uid style;               /* How to draw arc: arc, chord, or pieslice. */
    GC outlineGC;               /* Graphics context for outline. */
    GC fillGC;                  /* Graphics context for filling item. */
    double center1[2];          /* Coordinates of center of arc outline at
                                 * start (see ComputeArcOutline). */
    double center2[2];          /* Coordinates of center of arc outline at
                                 * start+extent (see ComputeArcOutline). */
    short col1, col2;
    short row1, row2;

} ArcItem;

/* $Log: xxl_incs.h,v $
 * Revision 1.2  1998/09/30 00:50:44  cthulhu
 * Update for tcl/tk 8.0.3.
 * */
