*DECK CDQAWC
      SUBROUTINE CDQAWC (LUN, KPRINT, IPASS)
C***BEGIN PROLOGUE  CDQAWC
C***PURPOSE  Quick check for DQAWC.
C***LIBRARY   SLATEC
C***TYPE      DOUBLE PRECISION (CQAWC-S, CDQAWC-D)
C***AUTHOR  (UNKNOWN)
C***ROUTINES CALLED  D1MACH, DF0C, DF1C, DPRIN, DQAWC
C***REVISION HISTORY  (YYMMDD)
C   ??????  DATE WRITTEN
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   901205  Added PASS/FAIL message and changed the name of the first
C           argument.  (RWC)
C   910501  Added PURPOSE and TYPE records.  (WRB)
C***END PROLOGUE  CDQAWC
C
C FOR FURTHER DOCUMENTATION SEE ROUTINE CQPDOC
C
      DOUBLE PRECISION A,ABSERR,B,D1MACH,EPMACH,EPSABS,
     *  EPSREL,ERROR,EXACT0,EXACT1,DF0C,DF1C,C,
     *  RESULT,UFLOW,WORK
      INTEGER IER,IP,IPASS,IWORK,KPRINT,LAST,LENW,LIMIT,NEVAL
      DIMENSION WORK(800),IWORK(200),IERV(2)
      EXTERNAL DF0C,DF1C
      DATA EXACT0/-0.6284617285065624D+03/
      DATA EXACT1/0.1855802D+01/
C***FIRST EXECUTABLE STATEMENT  CDQAWC
      IF (KPRINT.GE.2) WRITE (LUN, '(''1DQAWC QUICK CHECK''/)')
C
C TEST ON IER = 0
C
      IPASS = 1
      C = 0.5D+00
      A = -1.0D+00
      B = 1.0D+00
      LIMIT = 200
      LENW = LIMIT*4
      EPSABS = 0.0D+00
      EPMACH = D1MACH(4)
      EPSREL = MAX(SQRT(EPMACH),0.1D-07)
      CALL DQAWC(DF0C,A,B,C,EPSABS,EPSREL,RESULT,ABSERR,
     *  NEVAL,IER,LIMIT,LENW,LAST,IWORK,WORK)
      IERV(1) = IER
      IP = 0
      ERROR = ABS(EXACT0-RESULT)
      IF(IER.EQ.0.AND.ERROR.LE.ABSERR.AND.ABSERR.LE.EPSREL*ABS(EXACT0))
     *  IP = 1
      IF(IP.EQ.0) IPASS = 0
      CALL DPRIN(LUN,0,KPRINT,IP,EXACT0,RESULT,ABSERR,NEVAL,IERV,1)
C
C TEST ON IER = 1
C
      CALL DQAWC(DF0C,A,B,C,EPSABS,EPSREL,RESULT,ABSERR,
     *  NEVAL,IER,1,4,LAST,IWORK,WORK)
      IERV(1) = IER
      IP = 0
      IF(IER.EQ.1) IP = 1
      IF(IP.EQ.0) IPASS = 0
      CALL DPRIN(LUN,1,KPRINT,IP,EXACT0,RESULT,ABSERR,NEVAL,IERV,1)
C
C TEST ON IER = 2 OR 1
C
      UFLOW = D1MACH(1)
      CALL DQAWC(DF0C,A,B,C,UFLOW,0.0D+00,RESULT,ABSERR,
     *  NEVAL,IER,LIMIT,LENW,LAST,IWORK,WORK)
      IERV(1) = IER
      IERV(2) = 1
      IP = 0
      IF(IER.EQ.2.OR.IER.EQ.1) IP = 1
      IF(IP.EQ.0) IPASS = 0
      CALL DPRIN(LUN,2,KPRINT,IP,EXACT0,RESULT,ABSERR,NEVAL,IERV,2)
C
C TEST ON IER = 3 OR 1
C
      CALL DQAWC(DF1C,0.0D+00,B,C,UFLOW,0.0D+00,RESULT,ABSERR,
     *  NEVAL,IER,LIMIT,LENW,LAST,IWORK,WORK)
      IERV(1) = IER
      IERV(2) = 1
      IP = 0
      IF(IER.EQ.3.OR.IER.EQ.1) IP = 1
      IF(IP.EQ.0) IPASS = 0
      CALL DPRIN(LUN,3,KPRINT,IP,EXACT1,RESULT,ABSERR,NEVAL,IERV,2)
C
C TEST ON IER = 6
C
      EPSABS = 0.0D+00
      EPSREL = 0.0D+00
      CALL DQAWC(DF0C,A,B,C,EPSABS,EPSREL,RESULT,ABSERR,
     *  NEVAL,IER,LIMIT,LENW,LAST,IWORK,WORK)
      IERV(1) = IER
      IP = 0
      IF(IER.EQ.6) IP = 1
      IF(IP.EQ.0) IPASS = 0
      CALL DPRIN(LUN,6,KPRINT,IP,EXACT0,RESULT,ABSERR,NEVAL,IERV,1)
C
      IF (KPRINT.GE.1) THEN
         IF (IPASS.EQ.0) THEN
            WRITE(LUN, '(/'' SOME TEST(S) IN CDQAWC FAILED''/)')
         ELSEIF (KPRINT.GE.2) THEN
            WRITE(LUN, '(/'' ALL TEST(S) IN CDQAWC PASSED''/)')
         ENDIF
      ENDIF
      RETURN
      END
