#!/bin/sh
#
# Configure the library

# Create a file descriptor for talking to the user.
# (/dev/tty not supported on BeOS PR2)
exec 3>&1

# Echo a line without a trailing newline:
prompt()
{
	line="`echo '1\n2'`"
	if [ "$line" = '1\n2' ]; then
	    echo -n "$*" >&3
	else
	    echo "$*\c" >&3
	fi
}
# Find a program in the execution path:
findexe()
{
	exe=$1
	ifs=$IFS
	IFS=:
	set -- $PATH
	IFS=$ifs
	while [ $# -gt 0 ];
	do path=$1/$exe
           if [ -f $path -o -f $path.exe ]; then
		echo $path; return 0
	   fi
	   shift
	done
	return 1
}
# Strip the directory from a pathname
stripdir()
{
	ifs=$IFS
	IFS=/
	set -- $1
	IFS=$ifs
	while [ $# -gt 1 ]; do shift; done
	echo $1
}

# Let the user select which subsystem drivers to use for SDL
SelectSubsystems()
{
	choice="$*"
	while [ "$choice" != "" ]; do
		if [ "$choice" = "?" ]; then
			echo "" >&3
			for dir in `echo $subsystems | tr '[A-Z]' '[a-z]'`
			do  if [ -r "src/$target/$dir/.help" ]; then
				echo $dir:			>&3
				cat src/$target/$dir/.help	>&3
				echo ""				>&3
			    else
				echo "No help available for $dir on $target" >&3
			    fi
			done
		else
			subsystems=$choice
		fi
		echo "Choose $target interface methods (or ? for help)" >&3
		prompt "[$subsystems] "
		read choice
	done
	echo $subsystems | tr '[A-Z]' '[a-z]'
}

# Figure out target compilation
if [ "$1" = "" ]; then
    target=`uname | tr '[A-Z]' '[a-z]'`
else
    target=$1
fi
case $target in
	cygwin*) 
	    target="win32"
	    ;;
	*)
	    ;;
esac

# Make sure we're in the right directory
if [ ! -d src ]; then
    echo "Please run this script from the SDL toplevel directory"
    exit 1
fi

# Clear out the default options
includes=""; options=""; asmobjs=""; libraries=""; extralibs=""

# Include the system-specific functions
. make/$target/functions

# Generate the main Makefile config
subsystems=`SelectSubsystems $possible`
for subsystem in $subsystems
do  GenSubsystemFlags $subsystem
done
GenMakeFlags

# Set up links for the system dependent Makefile fragments
echo $target >.target

# Update the list of object directories
objdirs="obj obj/stub"
for subsystem in $subsystems
do objdirs="$objdirs obj/$subsystem"
done

# Build the system configuration
cat >.config <<__EOF__
#
# THIS CONFIGURATION AUTOMATICALLY GENERATED BY `stripdir $0` -- DO NOT EDIT
#
INCLUDES = $includes
OPTIONS = $options

ASM_OBJS = $asmobjs

EXTRA_LIBS = $extralibs

ifeq (\$(static), true)
all: obj lib \$(STATIC_LIB)
else
all: obj lib \$(STATIC_LIB) $libraries
endif

# Create the object directories
obj:
	mkdir $objdirs

# Create the library directories
lib:
	mkdir lib

# Dump object files into the 'obj' subdirectory
\$(patsubst %,%/%.o,$objdirs): %.c
	\$(CC) -c \$(CFLAGS) \$< -o \$@
\$(patsubst %,%/%.o,$objdirs): %.cc
	\$(CXX) -c \$(CFLAGS) \$< -o \$@
__EOF__

# We're done!
if findexe gmake >/dev/null; then
    make=gmake
else
    make=make
fi
echo ""
echo "Please type '$make' to build SDL for $target"
echo ""
