/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    5635-34 Springhouse Dr.
    Pleasanton, CA 94588 (USA)
    slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: SDL_mutex.h,v 1.4 1999/02/20 00:54:47 slouken Exp $";
#endif

#ifndef _SDL_mutex_h
#define _SDL_mutex_h

/* Functions to manipulate the semaphore locks 

	These are independent of the other SDL routines.
*/

#include "SDL_mangle.h"

#include "begin_code.h"

/* The SDL mutex structure, defined in SDL_mutex.c */
struct SDL_mutex;
typedef struct SDL_mutex SDL_mutex;

/* Create a mutex, initialized unlocked */
SDL_DEFUN(SDL_mutex *, SDL_CreateMutex, (void))
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_CreateMutex _SDL_CreateMutex
#endif
/**/

/* Lock the mutex  (Returns 0, or -1 on error) */
SDL_DEFUN(int, SDL_mutexP, (SDL_mutex *mutex))
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_mutexP _SDL_mutexP
#endif
/**/

/* Unlock the mutex  (Returns 0, or -1 on error) */
SDL_DEFUN(int, SDL_mutexV, (SDL_mutex *mutex))
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_mutexV _SDL_mutexV
#endif
/**/

/* Destroy a mutex */
SDL_DEFUN(void, SDL_DestroyMutex, (SDL_mutex *mutex))
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_DestroyMutex _SDL_DestroyMutex
#endif
/**/

#include "close_code.h"

#endif /* _SDL_mutex_h */
