/*$Id: md.h,v 15.18 1999/10/30 08:04:59 al Exp $ -*- C++ -*-
 * Machine dependent, configuration, and standard includes
 */
#ifndef MD_H_INCLUDED
#define MD_H_INCLUDED
/*--------------------------------------------------------------------------*/
/* system dependent patches needed before the standard includes */
#if defined(__GNUG__)
#define __HONOR_STD
#elif defined (WIN32)
#pragma warning (disable: 4786) // id truncated to 255 characters
#pragma warning (disable: 4800) // forcing ___ to bool (performance warning)
#pragma warning (disable: 4660) // template specialization already instantiated
// lev 4
#pragma warning (disable: 4514) // unreferenced inline removed
#pragma warning (disable: 4710) // function not inlined
#pragma warning (disable: 4512) // assignment op could not be generated
#pragma warning (disable: 4244) // conversion from int to char (toupper)
#pragma warning (disable: 4611) // setjmp / destructor interaction nonportable
#pragma warning (push, 3)
#endif
/*--------------------------------------------------------------------------*/
/* std collection of includes */
#include <cstdarg>
#include <cassert>
#include <cfloat>
#include <map>
#include <queue>
#include <typeinfo>
#include <algorithm>
#include <list>
#include <stack>
#include <csetjmp>
#include <vector>
#include <climits>
#include <cstdio>
#include <complex>
#include <string>
/*--------------------------------------------------------------------------*/
#if defined(UNIX)
/* usual but non-standard collection of includes */
#include <unistd.h>	  /* chdir, access, getcwd */
#include <sys/time.h>	  /* struct timeval, may be needed by sys/resource */
#include <sys/resource.h> /* getrusage, used for timer  */
/* file names, etc. */
#define	ENDDIR		"/"
#define PATHSEP		':'
#define SYSTEMSTARTFILE	"acs.rc"
#define SYSTEMSTARTPATH	OS::getenv("PATH")
#define USERSTARTFILE	".acsrc"
#define	USERSTARTPATH	OS::getenv("HOME")
#define STEPFILE   	"/tmp/SXXXXXX"
#define PLOTFILE    	"acs.plot"
#define HELPFILE    	"acs.hlp"
#define HELPPATH	OS::getenv("PATH")
/* constants related to memory size, word size, etc */
enum {
  BUFLEN = 256,
  BIGBUFLEN = 2048
};
/* machine and compiler patches */
#define CONST const
#if defined(__GNUG__)
  #define MANUAL_TEMPLATES
#else
  #define LINK_TEMPLATES
#endif
/*--------------------------------------------------------------------------*/
#elif defined(WIN32)
/* usual but non-standard collection of includes */
#include <windows.h>
#include <io.h>
#include <direct.h>
#include <time.h>
/* file names, etc. */
#define	ENDDIR		"/\\"
#define PATHSEP		';'
#define SYSTEMSTARTFILE	"acs.ini"
#define SYSTEMSTARTPATH	OS::getenv("PATH")
#define USERSTARTFILE	"acs.ini"
#define	USERSTARTPATH	OS::getenv("HOME")
#define STEPFILE   	"/tmp/SXXXXXX"
#define PLOTFILE    	"acs.plot"
#define HELPFILE    	"acs.hlp"
#define HELPPATH	OS::getenv("PATH")
/* constants related to memory size, word size, etc */
enum {
  BUFLEN = 256,
  BIGBUFLEN = 2048
};
/* machine and compiler patches */
#define MANUAL_TEMPLATES
#define NEEDS_GETRUSAGE
#define NEW_IS_BROKEN
#define SIGNALARGS int
#undef  CONST
#define CONST
#define F_OK (00)		/* io.h */
#define X_OK (01)
#define W_OK (02)
#define R_OK (04)
#define MAXPATHLEN (1024)
#define RUSAGE_SELF	0
#define sigjmp_buf jmp_buf
#define siglongjmp(a,b) longjmp(a,b)
#define sigsetjmp(a,b) setjmp(a)
#define PATH_MAX 1024
#undef min
#undef max
namespace std{
  template <class T>
  inline const T& min(const T& a, const T& b) {
    return b < a ? b : a;
  }
  template <class T>
  inline const T& max(const T& a, const T& b) {
    return  a < b ? b : a;
  }
}
inline int strcasecmp(const char a[], const char b[]){
  return stricmp(a,b);
}
inline int isinf(double x){
  if (_fpclass(x) == _FPCLASS_PINF){
    return 1;
  }else if (_fpclass(x) == _FPCLASS_NINF){
    return -1;
  }else{
    return 0;
  }
}
inline int isnan(double x){
  return _isnan(x);
}
const char __FUNCTION__[] = "";
/*--------------------------------------------------------------------------*/
#else
#error what kind of system is this??
#endif
/*--------------------------------------------------------------------------*/
/* my standard collection of includes */
#include "io_error.h"
#include "io_trace.h"
#include "io_.h"
/*--------------------------------------------------------------------------*/
typedef std::complex<double> COMPLEX;

#if defined(NDEBUG)
  #define prechecked_cast static_cast
#else
  #define prechecked_cast dynamic_cast
#endif

#if defined(HAS_EXP_BUG)
  inline double Exp(double x){untested(); return (x>-200.) ? exp(x) : 0.;}
#else
  inline double Exp(double x){return exp(x);}
#endif

#if defined(NEEDS_IS_INF)
int isinf(double x) {untested(); return (x != x);}
#endif

#if defined(NEEDS_IS_NAN)
int isnan(double x) {untested(); return (x != x);}
#endif

#if defined(NEEDS_GETRUSAGE)
struct	rusage {
  struct timeval ru_utime;	/* user time used */
  struct timeval ru_stime;	/* system time used */
};
int getrusage(int,struct rusage*);
#endif

#if !defined(SIGNALARGS)
  #define SIGNALARGS int
#endif
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
