/*$Id: l_stlextra.h,v 13.34 1999/05/03 08:18:39 al Exp $ -*- C++ -*-
 * extra functions in the STL style
 * Things that ought to be there, but are not
 */
#ifndef L_STLEXTRA_H
#define L_STLEXTRA_H
#include "md.h"
/*--------------------------------------------------------------------------*/
//InputIterator find_ptr(InputIterator first,InputIterator last,const T& value)
/*--------------------------------------------------------------------------*/
/* find_ptr: like the stl find, except that the list contains pointers
   Dereference the pointer in the list, then compare */
template <class InputIterator, class T>
InputIterator find_ptr(InputIterator first,InputIterator last,const T& value)
{
  while (first != last && **first != value)
    ++first;
  return first;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
